;--------------------------------------------------------------------------
; zdrojovy program ridiciho procesoru pro obsluhu jednoducheho citace
; ukazkovy priklad publikace Ucebnice programovani ATMEL
;--------------------------------------------------------------------------
; ver.1.0 (6.9.2001)
; definice parametru prekladu zdrojoveho kodu
; definice a mapovani adresovych prostoru
; definice zapojeni externiho hardware citace prirazenim symbolu
; zakladni realizace bloku inicializace a bloku hlavni smycky
; ver.1.1 (11.9.2001)
; definice promennych displeje
; inicializace displeje
; proces casovace 1 ms
; proces multiplexni obsluhy displeje
; ver.1.2 (13.9.2001)
; obsluha ridicich tlacitek citace
; proces mereni vstupni frekvence
;--------------------------------------------------------------------------
; blok parametru prekladu (zavisly na typu prekladace)
;--------------------------------------------------------------------------

$NOMOD51                                    ; vypnuti definice CPU
$INCLUDE (REG52.INC)                        ; vlozeni definic pouziteho CPU

;--------------------------------------------------------------------------
; blok definic adresovych prostoru
;--------------------------------------------------------------------------

NAME          CITAC                         ; definice nazvu modulu

STACK_SEG     SEGMENT   IDATA               ; segment zasobniku
              RSEG      STACK_SEG           ; ok 
STACK:        DS        20                  ; vyhrazeni 20 byte pro STACK

VAR_SEG       SEGMENT   DATA                ; segment promennych
              RSEG      VAR_SEG             ; ok
Pom:          DS        1                   ; pomocna promenna
PtrDISP:      DS        1                   ; ukazatel aktivniho znaku
TmrDISP:      DS        1                   ; casovac displeje
ZNAK1:        DS        1                   ; 1. znak displeje (z leva) 
ZNAK2:        DS        1                   ; 2. znak displeje
ZNAK3:        DS        1                   ; 3. znak displeje
ZNAK4:        DS        1                   ; 4. znak displeje
TmrKlv:       DS        1                   ; casovac obsluhy klavesnice
Exponent:     DS        1                   ; promenna exponentu kmitoctu
TmrMer:       DS        2                   ; casovac mereni frekvence
TmrBlik:      DS        1                   ; casovac bliknuti konce mereni
MerFrekv:     DS        2                   ; promenna namereneho kmitoctu

BIT_SEG       SEGMENT   BIT                 ; segment bitovych promennych
              RSEG      BIT_SEG             ; ok
TlPull:       DBIT      1                   ; priznak stisteneho tlacitka
ProcMer       EQU       TR0                 ; priznak spusteni mereni

;--------------------------------------------------------------------------
; blok definic konstant a zapojeni hardware
;--------------------------------------------------------------------------

CONST_SEG     SEGMENT   CODE                ; segment konstant
              RSEG      CONST_SEG           ; ok 
                                            ; prevodni tabulka znaku
                                            ; pri 0 segment sviti
TabZnak:      DB        00000011B           ; 0 
              DB        10011111B           ; 1
              DB        00100101B           ; 2
              DB        00001101B           ; 3 
              DB        10011001B           ; 4
              DB        01001001B           ; 5
              DB        00000101B           ; 6
              DB        00011111B           ; 7
              DB        00000001B           ; 8
              DB        00001001B           ; 9
                                            ; tabulka poradi anod
                                            ; pri 1 segment sviti 
TabANOD:      DB        00010000B           ; 1. znak
              DB        00100000B           ; 2. znak
              DB        01000000B           ; 3. znak
              DB        10000000B           ; 4. znak

InSTART       BIT       90H                 ; vstup tlacitka START
InSTOP        BIT       91H                 ; vstup tlacitka STOP
InCLR         BIT       92H                 ; vstup tlacitka CLR
InUP          BIT       93H                 ; vstup tlacitka UP
InDOWN        BIT       94H                 ; vstup tlacitka DOWN
              
ANDATA        EQU       P2                  ; symbol vystupu anod
DISPDATA      EQU       P0                  ; symbol vystupu dat displeje
GRPKLV        EQU       P1                  ; port vstupu tlacitek

;--------------------------------------------------------------------------
; blok hlavniho programu
;--------------------------------------------------------------------------

              CSEG  AT  0000H               ; absolutni segment programu
              USING     0                   ; registrova sada 0 
                                            ; zacatek po resetu procesoru 
              JMP   InitProg;               ; skok na inicializaci
              
              ORG   001BH                   ; vektor preruseni casovace T1
              JMP   MakeIntT1               ; skok na obsluhu
              
; procedura obslouzi preruseni od casovace T1                            
MakeIntT1:    PUSH  ACC                     ; ulozeni obsahu stradace
              PUSH  PSW                     ; a statusu CPU
              MOV   TH1,#0FCH               ; znovunaplneni T1
              MOV   TL1,#18H                ; na 1ms zpozdeni
              INC   TmrDISP                 ; zapocteni 1ms pro displej
              INC   TmrKlv                  ; zapocteni 1ms pro klavesy
              MOV   A,TmrMer                ; test nuloveho casovace mereni
              CJNE  A,#0,DecMer             ;
              MOV   A,TmrMer+1              ; 
              CJNE  A,#0,DecMer             ;
              JMP   NoHMer                  ; ok
DecMer:       CLR   C                       ; nulovat priznak prenosu
              MOV   A,TmrMer                ; odecteni 1 od TmrMer
              SUBB  A,#1                    ;
              MOV   TmrMer,A                ;
              JNC   NoHMer                  ; test prenosu do vyssiho radu
              DEC   TmrMer+1                ;
NoHMer:       POP   PSW                     ; obnova statusu CPU
              POP   ACC                     ; a stradace
              RETI                          ; ok
              
InitProg:                                   ; tady zacina inicializace
              MOV   SP,#STACK-1             ; nastaveni vrcholu zasobniku
              MOV   GRPKLV,#0FFH            ; nastaveni portu P1 jako vstup
              MOV   ANDATA,#0               ; zhasnuti displeje
              MOV   DISPDATA,#0FFH          ; ok 
              MOV   PtrDISP,#0              ; clr promennych displeje
              MOV   TmrDISP,#0              ;
              MOV   ZNAK1,#0                ;     
              MOV   ZNAK2,#0                ;   
              MOV   ZNAK3,#0                ;
              MOV   ZNAK4,#0                ; ok
              MOV   TmrKlv,#0               ; clr casovace klavesnice
              CLR   TlPull;                 ; clr priznaku stistene klavesy
              MOV   Exponent,#0             ; clr exponentu kmitoctu
              MOV   TmrMer,#0E8H            ; mereni po 1 s
              MOV   TmrMer+1,#03H           ; ok
              MOV   TmrBlik,#0              ; clr casovace bliku mereni
              MOV   TH0,#0                  ; clr casovace T0
              MOV   TL0,#0                  ; ok
              CLR   ProcMer                 ; stop procesu mereni
              MOV   TMOD,#00010101B         ; T0 a T1 je citac 16 bitu
              MOV   TH1,#0FCH               ; prvotni inicializace T1
              MOV   TL1,#18H                ; na 1ms zpozdeni
              SETB  TR1                     ; spusteni casovace T1
              SETB  ET1                     ; povoleni preruseni od T1
              SETB  EA                      ; povoleni vsech preruseni                               
                                            ; tady zacina hlavni smycka
                                            ; proces obsluhy displeje
MainLoop:     MOV   A,TmrDISP;              ; cas znaku do stradace
              CJNE  A,#10,NoDisp            ; test 10 ms trvani znaku
              MOV   TmrDISP,#0              ; clr casovace displeje
              MOV   A,#ZNAK1                ; adresa 1.znaku do A
              ADD   A,PtrDISP               ; adresa znaku z ukazatele
              MOV   R0,A                    ; ulozena do R0
              MOV   A,@R0                   ; data aktualniho znaku
              MOV   DPTR,#TabZnak           ; tabulka dekodovani znaku
              MOVC  A,@A+DPTR               ; zdekodovany znak do pameti
              MOV   Pom,A                   ; ok
              MOV   A,#2                    ; test 3. znaku s teckou
              CJNE  A,PtrDISP,NoPoint       ; ok
              MOV   A,TmrBlik               ; test podminky pro bliknuti
              CJNE  A,#0,Point              ;
              JMP   NoPoint                 ;
Point:        ANL   Pom,#11111110B          ; rozsviceni tecky radu
              DEC   TmrBlik                 ; ok
NoPoint:      MOV   ANDATA,#0               ; zhasnuti displeje 
              MOV   DispDATA,Pom            ; novy znak na segmenty
              MOV   DPTR,#TabANOD           ; ukazatel tabulky anod
              MOV   A,PtrDISP;              ; poradi znaku displeje
              MOVC  A,@A+DPTR;              ; zdetekovana aktivni anoda
              MOV   ANDATA,A                ; ok
              INC   PtrDISP;                ; ukazatel na dalsi znak
              ANL   PtrDISP,#03H            ; uzavreni cyku 4 znaku
                                            ; proces obsluhy klaves 
NoDisp:       MOV   A,TmrKlv;               ; cas cteni klaves do stradace
              CJNE  A,#50,NoKlv             ; test 50 ms prodlevy
              MOV   TmrKlv,#0               ; clr casovace klaves
              MOV   A,GRPKLV                ; stav tlacitek do stradace
              CJNE  A,#0FFH,TestPull        ; test stistene klavesy
              CLR   TlPull                  ; clr priznaku pri uvolneni
              JMP   NoKlv                   ; konec obsluhy klaves
TestPull:     JB    TlPull,NoKlv            ; znak je jiz stisten ?
              SETB  TlPull                  ; byla stistena nova klavesa
              JB    InSTART,TstSTOP         ; test tlacitka START
              MOV   TH0,#0                  ; clr casovace T0
              MOV   TL0,#0                  ; ok
              SETB  ProcMer                 ; spusteni procesu mereni
              JMP   NoKlv                   ; konec obsluhy klaves
TstSTOP:      JB    InSTOP,TstCLR           ; test tlacitka STOP
              CLR   ProcMer                 ; stop procesu mereni
              JMP   NoKlv                   ; konec obsluhy klaves
TstCLR:       JB    InCLR,TstUP             ; test tlacitka CLR
              MOV   ZNAK1,#0                ;     
              MOV   ZNAK2,#0                ;   
              MOV   ZNAK3,#0                ;
              JMP   NoKlv                   ; konec obsluhy klaves
TstUP:        JB    InUP,TstDOWN            ; test tlacitka UP
              MOV   A,Exponent              ; test horni meze exponentu
              CLR   C                       ; 
              SUBB  A,#2                    ;
              JNC   NoKlv                   ; jsme na mezi 2 ?
              INC   Exponent                ; zvyseni exponentu
              JMP   NoKlv                   ; konec obsluhy klaves
TstDOWN:      JB    InDOWN,NoKlv            ; test tlacitka DOWN
              MOV   A,Exponent              ; test dolni meze exponentu
              CJNE  A,#0,ExpDown            ;
              JMP   NoKlv                   ;
ExpDown:      DEC   Exponent                ; snizeni exponentu
NoKlv:        MOV   ZNAK4,Exponent          ; prenos exponentu na displej
                                            ; proces mereni kmitoctu
              JNB   ProcMer,NoMer           ; test procesu mereni
              MOV   A,TmrMer                ; test uplynuti casu mereni
              CJNE  A,#0,NoMer              ;
              MOV   A,TmrMer+1              ; 
              CJNE  A,#0,NoMer              ; ok
              CALL  DetMerTime              ; zdetekuje cas mereni dle radu
              MOV   MerFrekv,TL0            ; nacteni namereneho kmitoctu
              MOV   MerFrekv+1,TH0          ; ok
              MOV   TH0,#0                  ; clr casovace T0
              MOV   TL0,#0                  ; ok
NoMer:
              JMP   MainLoop;               ; skok na hlavni smycku

; procedura zdetekuje dle nastaveneho exponentu cas mereni
DetMerTime:   MOV   TmrBlik,#2              ; delka bliknuti 2 cyky disp.
              MOV   A,Exponent              ; exponent do stradace  
              CJNE  A,#2,DetMer1            ; je to rad EXP2
              MOV   TmrMer,#0AH             ; mereni po 10 ms
              MOV   TmrMer+1,#00H           ; ok
              RET                           ; konec procedury detekce
DetMer1:      CJNE  A,#1,DetMer2            ; je to rad EXP1
              MOV   TmrMer,#64H             ; mereni po 100 ms
              MOV   TmrMer+1,#00H           ; ok
              RET                           ; konec procedury detekce
DetMer2:      MOV   TmrMer,#0E8H            ; mereni po 1 s
              MOV   TmrMer+1,#03H           ; ok
              RET                           ; konec procedury detekce
              
;--------------------------------------------------------------------------
; konec programu
;--------------------------------------------------------------------------

              END                           ; konec prekladu programu
