;--------------------------------------------------------------------------
; zdrojovy program ridiciho procesoru pro obsluhu jednoducheho citace
; ukazkovy priklad publikace Ucebnice programovani ATMEL
;--------------------------------------------------------------------------
; ver.1.0 (6.9.2001)
; definice parametru prekladu zdrojoveho kodu
; definice a mapovani adresovych prostoru
; definice zapojeni externiho hardware citace prirazenim symbolu
; zakladni realizace bloku inicializace a bloku hlavni smycky
; ver.1.1 (11.9.2001)
; definice promennych displeje
; inicializace displeje
; proces casovace 1 ms
; proces multiplexni obsluhy displeje
;--------------------------------------------------------------------------
; blok parametru prekladu (zavisly na typu prekladace)
;--------------------------------------------------------------------------

$NOMOD51                                    ; vypnuti definice CPU
$INCLUDE (REG52.INC)                        ; vlozeni definic pouziteho CPU

;--------------------------------------------------------------------------
; blok definic adresovych prostoru
;--------------------------------------------------------------------------

NAME          CITAC                         ; definice nazvu modulu

STACK_SEG     SEGMENT   IDATA               ; segment zasobniku
              RSEG      STACK_SEG           ; ok 
STACK:        DS        20                  ; vyhrazeni 20 byte pro STACK

VAR_SEG       SEGMENT   DATA                ; segment promennych
              RSEG      VAR_SEG             ; ok
Pom:          DS        1                   ; pomocna promenna
PtrDISP:      DS        1                   ; ukazatel aktivniho znaku
TmrDISP:      DS        1                   ; casovac displeje
ZNAK1:        DS        1                   ; 1. znak displeje (z leva) 
ZNAK2:        DS        1                   ; 2. znak displeje
ZNAK3:        DS        1                   ; 3. znak displeje
ZNAK4:        DS        1                   ; 4. znak displeje

;--------------------------------------------------------------------------
; blok definic konstant a zapojeni hardware
;--------------------------------------------------------------------------

CONST_SEG     SEGMENT   CODE                ; segment konstant
              RSEG      CONST_SEG           ; ok 
                                            ; prevodni tabulka znaku
                                            ; pri 0 segment sviti
TabZnak:      DB        00000011B           ; 0 
              DB        10011111B           ; 1
              DB        00100101B           ; 2
              DB        00001101B           ; 3 
              DB        10011001B           ; 4
              DB        01001001B           ; 5
              DB        00000101B           ; 6
              DB        00011111B           ; 7
              DB        00000001B           ; 8
              DB        00001001B           ; 9
                                            ; tabulka poradi anod
                                            ; pri 1 segment sviti 
TabANOD:      DB        00010000B           ; 1. znak
              DB        00100000B           ; 2. znak
              DB        01000000B           ; 3. znak
              DB        10000000B           ; 4. znak

InSTART       BIT       90H                 ; vstup tlacitka START
InSTOP        BIT       91H                 ; vstup tlacitka STOP
InCLR         BIT       92H                 ; vstup tlacitka CLR
InUP          BIT       93H                 ; vstup tlacitka UP
InDOWN        BIT       94H                 ; vstup tlacitka DOWN
              
ANDATA        EQU       P2                  ; symbol vystupu anod
DISPDATA      EQU       P0                  ; symbol vystupu dat displeje      

;--------------------------------------------------------------------------
; blok hlavniho programu
;--------------------------------------------------------------------------

              CSEG  AT  0000H               ; absolutni segment programu
              USING     0                   ; registrova sada 0 
                                            ; zacatek po resetu procesoru 
              JMP   InitProg;               ; skok na inicializaci
              
              ORG   001BH                   ; obsluha preruseni casovace T1
              MOV   TH1,#0FCH               ; znovunaplneni T1
              MOV   TL1,#18H                ; na 1ms zpozdeni
              INC   TmrDISP                 ; zapocteni 1ms pro displej
              RETI                          ; ok 
              
InitProg:                                   ; tady zacina inicializace
              MOV   SP,#STACK-1             ; nastaveni vrcholu zasobniku
              MOV   ANDATA,#0               ; zhasnuti displeje
              MOV   DISPDATA,#0FFH          ; ok 
              MOV   PtrDISP,#0              ; clr promennych displeje
              MOV   TmrDISP,#0              ;
              MOV   ZNAK1,#0                ;     
              MOV   ZNAK2,#1                ;   
              MOV   ZNAK3,#2                ;
              MOV   ZNAK4,#3                ; ok
              MOV   TMOD,#00010101B         ; T0 a T1 je citac 16 bitu
              MOV   TH1,#0FCH               ; prvotni inicializace T1
              MOV   TL1,#18H                ; na 1ms zpozdeni
              SETB  TR1                     ; spusteni casovace T1
              SETB  ET1                     ; povoleni preruseni od T1
              SETB  EA                      ; povoleni vsech preruseni                               
MainLoop:                                   ; tady zacina hlavni smycka
              MOV   A,TmrDISP;              ; cas znaku do stradace
              CJNE  A,#10,NoDisp            ; test 10 ms trvani znaku
              MOV   TmrDISP,#0              ; clr casovace displeje
              MOV   A,#ZNAK1                ; adresa 1.znaku do A
              ADD   A,PtrDISP               ; adresa znaku z ukazatele
              MOV   R0,A                    ; ulozena do R0
              MOV   A,@R0                   ; data aktualniho znaku
              MOV   DPTR,#TabZnak           ; tabulka dekodovani znaku
              MOVC  A,@A+DPTR               ; zdekodovany znak do pameti
              MOV   Pom,A                   ; ok
              MOV   A,#2                    ; test 3. znaku s teckou
              CJNE  A,PtrDISP,NoPoint       ; ok 
              ANL   Pom,#11111110B          ; rozsviceni tecky radu 
NoPoint:      MOV   ANDATA,#0               ; zhasnuti displeje 
              MOV   DispDATA,Pom            ; novy znak na segmenty
              MOV   DPTR,#TabANOD           ; ukazatel tabulky anod
              MOV   A,PtrDISP;              ; poradi znaku displeje
              MOVC  A,@A+DPTR;              ; zdetekovana aktivni anoda
              MOV   ANDATA,A                ; ok
              INC   PtrDISP;                ; ukazatel na dalsi znak
              ANL   PtrDISP,#03H            ; uzavreni cyku 4 znaku 
NoDisp: 
              JMP   MainLoop;               ; skok na hlavni smycku

;--------------------------------------------------------------------------
; konec programu
;--------------------------------------------------------------------------

              END                           ; konec prekladu programu
