;--------------------------------------------------------------------------
; zdrojovy program ridiciho procesoru pro obsluhu jednoducheho citace
; ukazkovy priklad publikace Ucebnice programovani ATMEL
;--------------------------------------------------------------------------
; ver.1.0 (6.9.2001)
; definice parametru prekladu zdrojoveho kodu
; definice a mapovani adresovych prostoru
; definice zapojeni externiho hardware citace prirazenim symbolu
; zakladni realizace bloku inicializace a bloku hlavni smycky
;--------------------------------------------------------------------------
; blok parametru prekladu (zavisly na typu prekladace)
;--------------------------------------------------------------------------

$NOMOD51                                    ; vypnuti definice CPU
$INCLUDE (REG52.INC)                        ; vlozeni definic pouziteho CPU

;--------------------------------------------------------------------------
; blok definic adresovych prostoru
;--------------------------------------------------------------------------

NAME          CITAC                         ; definice nazvu modulu

STACK_SEG     SEGMENT   IDATA               ; segment zasobniku
              RSEG      STACK_SEG           ; ok 
STACK:        DS        20                  ; vyhrazeni 20 byte pro STACK

;--------------------------------------------------------------------------
; blok definic konstant a zapojeni hardware
;--------------------------------------------------------------------------

InSTART       BIT       90H                 ; vstup tlacitka START
InSTOP        BIT       91H                 ; vstup tlacitka STOP
InCLR         BIT       92H                 ; vstup tlacitka CLR
InUP          BIT       93H                 ; vstup tlacitka UP
InDOWN        BIT       94H                 ; vstup tlacitka DOWN
              
ANDATA        EQU       P2                  ; symbol vystupu anod
DISPDATA      EQU       P0                  ; symbol vystupu dat displeje      

;--------------------------------------------------------------------------
; blok hlavniho programu
;--------------------------------------------------------------------------

              CSEG  AT  0000H               ; absolutni segment programu
                                            ; zacatek po resetu procesoru 
              JMP   InitProg;               ; skok na inicializaci
              
InitProg:                                   ; tady zacina inicializace
              
MainLoop:                                   ; tady zacina hlavni smycka
              
              JMP   MainLoop;               ; skok na hlavni smycku

;--------------------------------------------------------------------------
; konec programu
;--------------------------------------------------------------------------

              END                           ; konec prekladu programu
