/****************************************************
Soubor: ZapisCopyrightu.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "resource.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CDialogImpl< Aplikace >
{
public :
	DECLARE_LIBID(LIBID_ATLLib)
	enum { IDD = IDD_HLAVNI };

	static int CALLBACK BrowseCallbackProc(HWND hWnd,
		UINT uMsg, LPARAM lParam, LPARAM lpData)
	{
		wchar_t szDir[MAX_PATH];
		switch (uMsg)
		{
		case BFFM_INITIALIZED:
			if (lpData)
				::SendMessage(hWnd,
				BFFM_SETSELECTION,
				TRUE, (LPARAM)lpData);
			break;
		case BFFM_SELCHANGED:
			if (SHGetPathFromIDList(
				(LPITEMIDLIST)lParam, szDir))
				::SendMessage(hWnd,
				BFFM_SETSTATUSTEXT, 0, (LPARAM)szDir);
			break;
		}
		return 0;
	}

	static int GetKodekClsid(const wchar_t* format,
		CLSID* pClsid)
	{
		UINT num = 0; // poet enkodr
		UINT size = 0; // velikost pole enkodr v bytech
		ImageCodecInfo* pImageCodecInfo = NULL;
		GetImageEncodersSize(&num, &size);
		if (size == 0)
			return -1;  // Chyba
		pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
		if (!pImageCodecInfo)
			return -1;  // Chyba
		GetImageEncoders(num, size, pImageCodecInfo);
		for (UINT j = 0; j < num; ++j)
		{
			if (wcscmp(pImageCodecInfo[j].MimeType,
				format) == 0)
			{
				*pClsid = pImageCodecInfo[j].Clsid;
				free(pImageCodecInfo);
				return j;  // V podku
			}    
		}
		free(pImageCodecInfo);
		return -1; // Chyba
	}


public:
	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnKonec)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnKonec)
		COMMAND_HANDLER(IDC_VYBRAT_SLOZKU, BN_CLICKED, OnVybratSlozku)
		COMMAND_HANDLER(IDC_ZPRACOVAT, BN_CLICKED, OnZpracovat)
	END_MSG_MAP()

	HRESULT PreMessageLoop(int nShowCmd)
{
	__super::PreMessageLoop(nShowCmd);
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;
	ULONG_PTR gdiplusToken;
	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;

	DoModal();

	GdiplusShutdown(gdiplusToken);
	Unlock();
	return S_FALSE;
}

LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	HICON hicon = LoadIcon(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDI_HLAVNI));
	SetIcon(hicon, TRUE);
	SetIcon(hicon, FALSE);
	CString text;
	text.LoadStringW(IDS_PROJNAME);
	SetWindowText(text);
	return TRUE;
}


LRESULT OnKonec(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}


LRESULT OnVybratSlozku(WORD, WORD wID, HWND, BOOL&)
{
	wchar_t slozka[MAX_PATH];
	GetDlgItemText(IDC_SLOZKA, slozka, MAX_PATH);
	if (wcslen(slozka) == 0)
	{
		GetCurrentDirectory(sizeof(slozka)/sizeof(wchar_t),
			slozka);
	}
	LPITEMIDLIST pidl = NULL;
	BROWSEINFO bi;
	ZeroMemory(&bi, sizeof(bi));
	LPMALLOC pMalloc = NULL;
	SHGetMalloc(&pMalloc);
	bi.hwndOwner = m_hWnd;
	bi.pszDisplayName = 0;
	bi.pidlRoot = 0;
	bi.lParam = (LPARAM)slozka;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;
	bi.lpfn = BrowseCallbackProc;
	bi.lpszTitle = L"Vyberte poadovanou sloku";
	pidl = SHBrowseForFolder(&bi);
	if (pidl)
	{
		SHGetPathFromIDList(pidl, slozka);
		pMalloc->Free(pidl);
	}
	pMalloc->Release();
	SetDlgItemText(IDC_SLOZKA, slozka);
	return 0;
}

LRESULT OnZpracovat(WORD, WORD wID, HWND, BOOL&)
{
	wchar_t slozka[MAX_PATH];
	wchar_t slozkaVystup[MAX_PATH];
	wchar_t maska[MAX_PATH];
	wchar_t vstup[MAX_PATH];
	wchar_t vystup[MAX_PATH];
	wchar_t copyright[] = L" 2000-2006 Radek Chalupa";
	GetDlgItemText(IDC_SLOZKA, slozka, MAX_PATH);
	if (!PathFileExists(slozka))
	{
		MessageBox(L"Nen vybran sloka",
			L"Chyba", MB_ICONERROR);
		return 0;
	}
	wcscpy_s(slozkaVystup,
		_countof(slozkaVystup), slozka);
	wcscat_s(slozkaVystup,
		_countof(slozkaVystup), L"\\Vystup");
	wcscpy_s(maska,	_countof(maska), slozka);
	wcscat_s(maska,
		_countof(maska), L"\\*.jpg");

	if (!PathFileExists(slozkaVystup))
		if (!CreateDirectory(slozkaVystup, NULL))
		{
			MessageBox(L"Nepodilo se vytvoit sloku",
				L"Chyba", MB_ICONERROR);
		return 0;
		}
		
	WIN32_FIND_DATA wfd;
	HANDLE hFind = FindFirstFile(maska, &wfd);
	if (hFind == INVALID_HANDLE_VALUE)
		return 0;
	Bitmap* bitmap = NULL;
	Graphics* gr = NULL;
	Font font(L"Verdana", 26, FontStyleBold);
	SolidBrush brush(Color(160, 255, 255, 0));
	do
	{
		wcscpy_s(vstup, _countof(vstup), slozka);
		wcscat_s(vstup, _countof(vstup), L"\\");
		wcscat_s(vstup, _countof(vstup), wfd.cFileName);

		wcscpy_s(vystup, _countof(vystup), slozkaVystup);
		wcscat_s(vystup, _countof(vystup), L"\\");
		wcscat_s(vystup, _countof(vystup), wfd.cFileName);

		bitmap = new Bitmap(vstup);
		gr = Graphics::FromImage(bitmap);

		StringFormat format;
		format.SetAlignment(StringAlignmentCenter);
		format.SetLineAlignment(StringAlignmentCenter);
		RectF rectF(0, 0,
			(REAL)bitmap->GetWidth(), (REAL)bitmap->GetHeight());

		gr->DrawString(copyright, -1,
			&font, 
			rectF, &format, &brush);

		CLSID encoderCLSID;
		GetKodekClsid(L"image/jpeg", &encoderCLSID);
		bitmap->Save(vystup, &encoderCLSID);
		delete gr;
		delete bitmap;
	}
	while (FindNextFileW(hFind, &wfd));
	FindClose(hFind);
	MessageBox(L"Hotovo");

	return 0;
}

};


Aplikace _AtlModule;


extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _AtlModule.WinMain(nShowCmd);
}



