/****************************************************
Soubor: UpravaExif.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "resource.h"
#include "UpravaExif.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CDialogImpl< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)
	enum { IDD = IDD_HLAVNI };

public:
	HICON hicon;
	HICON hiconMala;
	CString jmeno;
	ULONG_PTR gdiplusToken;
	Bitmap* bitmap;
	wchar_t soubor[MAX_PATH];

	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_DRAWITEM, OnDrawItem)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnKonec)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnKonec)
		COMMAND_HANDLER(IDC_OTEVRIT, BN_CLICKED, OnOtevrit)
		COMMAND_HANDLER(IDC_ULOZIT, BN_CLICKED, OnUlozit)
		COMMAND_HANDLER(IDC_ZAVRIT, BN_CLICKED, OnZavrit)
		REFLECT_NOTIFICATIONS()
	END_MSG_MAP()

	Aplikace()
	{
		this->bitmap = NULL;
	}


int GetEncoderClsidPripona(const wchar_t* priponaSouboru,
	CLSID* pClsid)
{
	CString strPripona = CString(priponaSouboru);
	strPripona.MakeUpper();
	UINT pocet = 0; // poet kodek
	UINT velikost = 0; // velikost pole kodek
	ImageCodecInfo* pImageCodecInfo = NULL;
	GetImageEncodersSize(&pocet, &velikost);
	if (velikost == 0)
		return -1;  // Chyba
	pImageCodecInfo = (ImageCodecInfo*)(malloc(velikost));
	if (!pImageCodecInfo)
		return -1;  // Chyba
	GetImageEncoders(pocet, velikost, pImageCodecInfo);
	for (UINT j = 0; j < pocet; ++j)
	{
		if (wcsstr(pImageCodecInfo[j].FilenameExtension,
			strPripona.GetBuffer()) != NULL)
		{
			*pClsid = pImageCodecInfo[j].Clsid;
			free(pImageCodecInfo);
			return j;  // V podku
		}    
	}
	free(pImageCodecInfo);
	return -1; // Chyba
}

LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	SetWindowText(jmeno);
	SetIcon(this->hicon, TRUE);
	SetIcon(this->hiconMala, FALSE);
	return 1;
}


HRESULT PreMessageLoop(int nShowCmd)
{
	__super::PreMessageLoop(nShowCmd);
	Lock();
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;

	this->hicon = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR);
	if (!this->hicon)
		return E_HANDLE;
	this->hiconMala = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	if (!this->hiconMala)
		return E_HANDLE;

	DoModal();

	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	if (this->hicon)
	{
		DestroyIcon(this->hicon);
		this->hicon = NULL;
	}
	if (this->hiconMala)
	{
		DestroyIcon(this->hiconMala);
		this->hiconMala = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return S_FALSE;
	
}

LRESULT OnKonec(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}


LRESULT OnOtevrit(WORD, WORD wID, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	if (this->bitmap)
		delete bitmap;

	SetDlgItemText(IDC_AUTOR, L"");
	SetDlgItemText(IDC_COPYRIGHT, L"");
	SetDlgItemText(IDC_POPIS, L"");

	this->bitmap = new Bitmap(this->soubor);
	if (this->bitmap->GetLastStatus() != Ok)
	{
		delete this->bitmap;
		this->bitmap = NULL;
		return 0;
	}

	CString text;

	GetDlgItem(IDC_OBRAZEK).RedrawWindow();
	UINT velikost;
	PropertyItem* pi;

	velikost = this->bitmap->GetPropertyItemSize(
		PropertyTagImageDescription);
	if (velikost != 0)
	{
		pi = (PropertyItem*)malloc(velikost);
		this->bitmap->GetPropertyItem(
			PropertyTagImageDescription, velikost, pi);
		if (pi->type == PropertyTagTypeASCII)
			SetDlgItemText(IDC_POPIS,
			CString((LPCSTR)pi->value));
		free(pi);
	}

	velikost = this->bitmap->GetPropertyItemSize(PropertyTagArtist);
	if (velikost != 0)
	{
		pi = (PropertyItem*)malloc(velikost);
		this->bitmap->GetPropertyItem(PropertyTagArtist, velikost, pi);
		if (pi->type == PropertyTagTypeASCII)
			SetDlgItemText(IDC_AUTOR,
			CString((LPCSTR)pi->value));
		free(pi);
	}

	velikost = this->bitmap->GetPropertyItemSize(
		PropertyTagCopyright);
	if (velikost != 0)
	{
		pi = (PropertyItem*)malloc(velikost);
		this->bitmap->GetPropertyItem(
			PropertyTagCopyright, velikost, pi);
		if (pi->type == PropertyTagTypeASCII)
			SetDlgItemText(IDC_COPYRIGHT,
			CString((LPCSTR)pi->value));
		free(pi);
	}

	return 0;
}


LRESULT OnUlozit(WORD, WORD wID, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	PropertyItem* propertyItem = new PropertyItem();
	CString text;

	GetDlgItemText(IDC_POPIS, text);
	if (text.GetLength() > 0)
	{
		propertyItem->id = PropertyTagImageDescription;
		propertyItem->length = (ULONG)(text.GetLength() + 1);
		propertyItem->type = PropertyTagTypeASCII; 
		CStringA strA = 
			CStringA(CString(text.GetBuffer()).GetBuffer()); 
		propertyItem->value = strA.GetBuffer();
		bitmap->SetPropertyItem(propertyItem);
	}

	GetDlgItemText(IDC_AUTOR, text);
	if (text.GetLength() > 0)
	{
		propertyItem->id = PropertyTagArtist;
		propertyItem->length = (ULONG)(text.GetLength() + 1);
		propertyItem->type = PropertyTagTypeASCII; 
		CStringA strA = 
			CStringA(CString(text.GetBuffer()).GetBuffer()); 
		propertyItem->value = strA.GetBuffer();
		bitmap->SetPropertyItem(propertyItem);
	}

	GetDlgItemText(IDC_COPYRIGHT, text);
	if (text.GetLength() > 0)
	{
		propertyItem->id = PropertyTagCopyright;
		propertyItem->length = (ULONG)(text.GetLength() + 1);
		propertyItem->type = PropertyTagTypeASCII; 
		CStringA strA = 
			CStringA(CString(text.GetBuffer()).GetBuffer()); 
		propertyItem->value = strA.GetBuffer();
		bitmap->SetPropertyItem(propertyItem);
	}

	delete propertyItem;

	CString souborPom = CString(this->soubor);
	souborPom.Append(L"_temp_");
	souborPom.Append(PathFindExtensionW(this->soubor));
	UlozitJako(souborPom.GetBuffer());
	delete this->bitmap;
	DeleteFile(this->soubor);
	MoveFile(souborPom.GetBuffer(), this->soubor);
	this->bitmap = new Bitmap(this->soubor);

	return 0;
}

bool UlozitJako(const wchar_t* jmenoSouboru)
{
	if (!this->bitmap)
		return false;
	CLSID clsid;
	GetEncoderClsidPripona(PathFindExtensionW(jmenoSouboru), &clsid);
	return (this->bitmap->Save(jmenoSouboru, &clsid) == Ok);
}


LRESULT OnZavrit(WORD, WORD wID, HWND, BOOL&)
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	SetDlgItemText(IDC_AUTOR, L"");
	SetDlgItemText(IDC_COPYRIGHT, L"");
	SetDlgItemText(IDC_POPIS, L"");
	RedrawWindow();
	return 0;
}


LRESULT OnDrawItem(UINT, WPARAM, LPARAM lParam, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	if (((DRAWITEMSTRUCT*)lParam)->CtlID != IDC_OBRAZEK)
		return DefWindowProc();

	long xPoz = ((DRAWITEMSTRUCT*)lParam)->rcItem.left;
	long yPoz = ((DRAWITEMSTRUCT*)lParam)->rcItem.top;
	long sirka = ((DRAWITEMSTRUCT*)lParam)->rcItem.right -
		((DRAWITEMSTRUCT*)lParam)->rcItem.left;
	long vyska = ((DRAWITEMSTRUCT*)lParam)->rcItem.bottom -
		((DRAWITEMSTRUCT*)lParam)->rcItem.top;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
			sirka = (bitmap->GetWidth()*vyska ) /
			bitmap->GetHeight();
		else
			vyska = (bitmap->GetHeight()*sirka ) /
			bitmap->GetWidth();
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
	}
	Graphics graphics((HDC)((DRAWITEMSTRUCT*)lParam)->hDC);
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	return (graphics.DrawImage(
		bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel) == Ok);
	return 0;
}

};

Aplikace _aplikace;



//
extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}

