/****************************************************
Soubor: OknoHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoHlavni : public CWindowImpl < OknoHlavni >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"UkladaniObrazku",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

public:
	Bitmap* bitmap;
	wchar_t soubor[MAX_PATH];

public:
	OknoHlavni()
	{
		this->bitmap = NULL;
	}

	~OknoHlavni()
	{
		if (this->bitmap)
			delete this->bitmap;
	}

public:
	BEGIN_MSG_MAP(OknoHlavni)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_ULOZIT, OnUlozit)
		COMMAND_ID_HANDLER(ID_ULOZIT_JPEG, OnUlozitJpeg)
	END_MSG_MAP()

// callback procedura pro funkci SHBrowseForFolder
static int CALLBACK BrowseCallbackProc(HWND hWnd,
	UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	wchar_t szDir[MAX_PATH];
	switch (uMsg)
	{
		case BFFM_INITIALIZED:
			if (lpData)
				::SendMessage(hWnd, BFFM_SETSELECTION,
					1, (LPARAM)lpData);
			break;
		case BFFM_SELCHANGED:
			if (SHGetPathFromIDList(
				(LPITEMIDLIST)lParam, szDir))
				::SendMessage(hWnd, BFFM_SETSTATUSTEXT,
					0, (LPARAM)szDir);
			break;
	}
	return 0;
}

int GetEncoderClsidPripona(const wchar_t* priponaSouboru,
	CLSID* pClsid)
{
	CString strPripona = CString(priponaSouboru);
	strPripona.MakeUpper();
	UINT pocet = 0; // poet grafickch enkodr
	UINT velikost = 0; // velikost pole obrazovch enkodr
	ImageCodecInfo* pImageCodecInfo = NULL;
	GetImageEncodersSize(&pocet, &velikost);
	if (velikost == 0)
		return -1;  // Chyba
	pImageCodecInfo =
		(ImageCodecInfo*)(malloc(velikost));
	if (!pImageCodecInfo)
		return -1;  // Chyba
	GetImageEncoders(pocet, velikost, pImageCodecInfo);
	for (UINT i = 0; i < pocet; i++)
	{
		if (wcsstr(pImageCodecInfo[i].FilenameExtension,
			strPripona.GetBuffer()) != NULL)
		{
			*pClsid = pImageCodecInfo[i].Clsid;
			free(pImageCodecInfo);
			return i;  // V podku
		}    
	}
	free(pImageCodecInfo);
	return -1; // Chyba
}

int GetEncoderClsid(const wchar_t* format,
	CLSID* pClsid)
{
	UINT pocet = 0; // poet grafickch enkodr
	UINT velikost = 0; // velikost pole obrazovch enkodr
	ImageCodecInfo* pImageCodecInfo = NULL;
	GetImageEncodersSize(&pocet, &velikost);
	if (velikost == 0)
		return -1;  // Chyba
	pImageCodecInfo = (ImageCodecInfo*)(malloc(velikost));
	if (!pImageCodecInfo)
		return -1;  // Chyba
	GetImageEncoders(pocet, velikost, pImageCodecInfo);
	for (UINT i = 0; i < pocet; i++)
	{
		if (wcscmp(pImageCodecInfo[i].MimeType, format) == 0)
		{
			*pClsid = pImageCodecInfo[i].Clsid;
			free(pImageCodecInfo);
			return i;  // V podku
		}    
	}
	free(pImageCodecInfo);
	return -1; // Chyba
}


void Chyba(const wchar_t* text)
{
	MessageBox(text, _aplikace.jmeno,
		MB_ICONERROR | MB_SETFOREGROUND);
}

LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	return DefWindowProc();
}

bool Vytvorit()
{
	RECT rect = {0, 0, 800, 600};
	if (!Create(NULL, rect, _aplikace.jmeno,
		WS_OVERLAPPEDWINDOW))
		return false;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return true;
}

LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	OtevritSoubor(this->soubor);
	return 0;
}

LRESULT OnUlozit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = 0;
	if (!GetSaveFileName(&ofn))
		return 0;
	CLSID clsid;
	if (GetEncoderClsidPripona(PathFindExtensionW(
		this->soubor), &clsid) < 0)
	{
		Chyba(L"Nepodailo se nalzt kodek");
		return 0;
	}
	if (this->bitmap->Save(this->soubor, &clsid) != Ok)
		Chyba(L"Pi ukldn dolo k chyb");
	return 0;
}

LRESULT OnUlozitJpeg(WORD, WORD, HWND, BOOL&)
{
	wchar_t slozka[MAX_PATH];
	GetCurrentDirectory(sizeof(slozka)/sizeof(wchar_t),
		slozka);
	bool bResult = true;
	LPITEMIDLIST pidl = NULL;
	BROWSEINFO bi;
	memset(&bi, 0, sizeof(bi));
	LPMALLOC pMalloc = NULL;
	SHGetMalloc(&pMalloc);
	bi.hwndOwner = m_hWnd;
	bi.pszDisplayName = 0;
	bi.pidlRoot = 0;
	bi.lParam = (LPARAM)slozka;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_STATUSTEXT;
	bi.lpfn = BrowseCallbackProc;
	bi.lpszTitle = L"Vyberte poadovanou sloku";
	pidl= SHBrowseForFolder(&bi);
	if (pidl)
	{
		if (!SHGetPathFromIDList(pidl, slozka))
		{
			pMalloc->Free(pidl);
			pMalloc->Release();
			return 0;
		}
	}
	pMalloc->Free(pidl);
	pMalloc->Release();
	CString soubor;
	for (ULONG i = 0; i <= 100; i += 5)
	{
		soubor.Format(L"%s\\kvalita_%d.jpg",
			slozka, i);
		UlozitJpeg(soubor, i);
	}
	return 0;
}

bool UlozitJpeg(const wchar_t* soubor, ULONG kvalita)
{
	if (!this->bitmap)
		return false;
	CLSID clsid;
	GetEncoderClsid(L"image/jpeg", &clsid);
	if (kvalita >= 0 && kvalita <= 100)
	{
		EncoderParameters ePar;
		ePar.Count = 1;
		ePar.Parameter[0].Guid = EncoderQuality;
		ePar.Parameter[0].Type = EncoderParameterValueTypeLong;
		ePar.Parameter[0].NumberOfValues = 1;
		ePar.Parameter[0].Value = &kvalita;
		return (this->bitmap->Save(soubor, &clsid, &ePar) == Ok);
	}
	else
		return (this->bitmap->Save(soubor, &clsid) == Ok);
}

void ZavritSoubor()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

bool OtevritSoubor(const wchar_t* soubor)
{
	ZavritSoubor();
	this->bitmap = new Bitmap(soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		return false;
	}
	else
	{
		wcscpy_s(this->soubor,
			_countof(this->soubor),	soubor);
		RedrawWindow();
		return true;
	}
}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics* graphics = new Graphics(hdc);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);
	delete graphics;
	EndPaint(&ps);
	return 0;
}

};

extern OknoHlavni _oknoHlavni;
