/****************************************************
Soubor: Pruhlednost.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_DESKTOP + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"UkazovaAplikace",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	static int GetKodekClsid(const wchar_t* format,
		CLSID* pClsid)
	{
		UINT num = 0; // poet enkodr
		UINT size = 0; // velikost pole enkodr v bytech
		ImageCodecInfo* pImageCodecInfo = NULL;
		GetImageEncodersSize(&num, &size);
		if (size == 0)
			return -1;  // Chyba
		pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
		if (!pImageCodecInfo)
			return -1;  // Chyba
		GetImageEncoders(num, size, pImageCodecInfo);
		for (UINT j = 0; j < num; ++j)
		{
			if (wcscmp(pImageCodecInfo[j].MimeType,
				format) == 0)
			{
				*pClsid = pImageCodecInfo[j].Clsid;
				free(pImageCodecInfo);
				return j;  // V podku
			}    
		}
		free(pImageCodecInfo);
		return -1; // Chyba
	}

public:
	CString jmeno;
	ULONG_PTR gdiplusToken;
	wchar_t soubor[MAX_PATH];
	Bitmap* bitmap;
	Bitmap* bitmapPozadi;
	HBRUSH hbrushPozadi;

public:
	HRESULT PreMessageLoop(int nShowCmd);
	HRESULT PostMessageLoop();

	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_PRUHLEDNOST_PRECHOD,
			OnPruhlednostPrechod)
		COMMAND_ID_HANDLER(ID_PRUHLEDNOST_STRED,
			OnPruhlednostStred)
		COMMAND_ID_HANDLER(ID_ZRUSIT_PRUHLEDNOST,
			OnZrusitPruhlednost)
		COMMAND_ID_HANDLER(ID_ULOZIT, OnUlozit)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBkgnd)
	END_MSG_MAP()

	LRESULT OnEraseBkgnd(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&);
	LRESULT OnKonec(WORD, WORD, HWND, BOOL&);
	LRESULT OnPruhlednostStred(WORD, WORD, HWND, BOOL&);
	LRESULT OnPruhlednostPrechod(WORD, WORD, HWND, BOOL&);
	LRESULT OnUlozit(WORD, WORD, HWND, BOOL&);
	LRESULT OnZrusitPruhlednost(WORD, WORD, HWND, BOOL&);
};

extern Aplikace _aplikace;
