/****************************************************
Soubor: Pruhlednost.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "Pruhlednost.h"

Aplikace _aplikace;


extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}

HRESULT Aplikace::PreMessageLoop(int nShowCmd)
{
	this->bitmap = NULL;
	this->bitmapPozadi = NULL;
	this->hbrushPozadi = NULL;
	wcscpy_s(this->soubor, _countof(this->soubor), L"");
	__super::PreMessageLoop(nShowCmd);

	Lock();
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	
	RECT rect = { 0, 0, 800, 600 };
	if (!Create(NULL, rect, jmeno, WS_OVERLAPPEDWINDOW, 0))
		return E_FAIL;
	hbrushPozadi = CreatePatternBrush(
		LoadBitmap(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDB_POZADI)));
	DragAcceptFiles(TRUE);
	CenterWindow();
	ShowWindow(SW_SHOW);
	return S_OK;
}

HRESULT Aplikace::PostMessageLoop()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	if (this->bitmapPozadi)
	{
		delete this->bitmapPozadi;
		this->bitmapPozadi = NULL;
	}
	if (hbrushPozadi)
	{
		DeleteObject(hbrushPozadi);
		hbrushPozadi = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return __super::PostMessageLoop();
}

LRESULT Aplikace::OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT Aplikace::OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return 0;
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);

	Graphics graphics(hdc);
	RECT rect;
	GetClientRect(&rect);
	FillRect(hdc, &rect, hbrushPozadi);

	UINT sirka = (UINT)rect.right;
	UINT vyska = (UINT)rect.bottom;
	if (sirka < bitmap->GetWidth() ||
		vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
		else
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
	}
	Rect rectCil(0, 0, sirka, vyska);
	graphics.DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);

	EndPaint(&ps);
	return 0;
}

LRESULT Aplikace::OnUlozit(WORD, WORD, HWND, BOOL&)
{
	wchar_t soubor[MAX_PATH] = {0};
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter =
		L"PNG formt (*.png)\0*.png\0";
	ofn.nFilterIndex = 1;
	if (!GetSaveFileName(&ofn))
		return 0;

	CLSID encoderCLSID;
	GetKodekClsid(L"image/png", &encoderCLSID);
	
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat32bppARGB, &bData);
	Bitmap* b = new Bitmap(this->bitmap->GetWidth(),
		this->bitmap->GetHeight(),
		bData.Stride,
		PixelFormat32bppARGB,
		(BYTE*)bData.Scan0);

	b->Save(soubor, &encoderCLSID);
	delete b;
	bitmap->UnlockBits(&bData);
	return 0;
}

LRESULT Aplikace::OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;

	if (this->bitmap)
		delete this->bitmap;
	this->bitmap = new Bitmap(this->soubor);

	RedrawWindow();
	return 0;
}

LRESULT Aplikace::OnPruhlednostStred(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat32bppARGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pStart = pData;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 4));
	int bytuNaRadek = bData.Width * 4;
	int bytuNaSloupec = bData.Height * 4;
	int sloupec;
	int radek;
	int r2, s2;
	int vzdalenost;
	int polomer = (bData.Height < bData.Width) ?
		bData.Height / 2 : bData.Width / 2;
	while (pData < pKonec)
	{
		sloupec = ((pData-pStart)%bytuNaRadek) / 4;
		radek = ((pData-pStart)/bytuNaRadek);
		r2 = abs((int)(radek - (bData.Height/2)));
		r2 *= r2;
		s2 = abs((int)(sloupec - (bData.Width/2)));
		s2 *= s2;
		vzdalenost = sqrt((double)(r2+s2));
		if (vzdalenost > polomer)
			*(pData+3) = 0;
		else
			*(pData+3) = 255 - ((255 * vzdalenost) / polomer);
		pData += 4;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT Aplikace::OnPruhlednostPrechod(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat32bppARGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pStart = pData;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 4));
	int bytuNaRadek = bData.Width * 4;
	int sloupec;
	while (pData < pKonec)
	{
		sloupec = ((pData-pStart)%bytuNaRadek) / 4;
		*(pData+3) = (255 * sloupec) / bData.Width;
		pData += 4;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT Aplikace::OnZrusitPruhlednost(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat32bppARGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pStart = pData;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 4));
	while (pData < pKonec)
	{
		*(pData+3) = 255;
		pData += 4;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT Aplikace::OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}


LRESULT Aplikace::OnEraseBkgnd(UINT, WPARAM, LPARAM, BOOL&)
{
	return this->bitmap ? 0 : DefWindowProc();
}
