/****************************************************
Soubor: Aplikace.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"
#include "PromitaniObrazkuShellExt.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// Aplikace
class ATL_NO_VTABLE Aplikace :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<Aplikace, &CLSID_PromitaniObrazkuShellExt>,
	public IShellExtInit,
	public IContextMenu,
	public IDispatchImpl<IPromitaniObrazkuShellExt,
		&IID_IPromitaniObrazkuShellExt,
		&LIBID_PromitaniObrazkuShellExtLib, 1, 0>
{
public:
	CAtlArray<CString> soubory;


DECLARE_REGISTRY_RESOURCEID(IDR_PROMITANIOBRAZKUSHELLEXT1)
DECLARE_PROTECT_FINAL_CONSTRUCT()


BEGIN_COM_MAP(Aplikace)
	COM_INTERFACE_ENTRY(IPromitaniObrazkuShellExt)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IShellExtInit)
	COM_INTERFACE_ENTRY(IContextMenu)
END_COM_MAP()

public:
	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}


STDMETHOD(Initialize)(LPCITEMIDLIST pidlFolder,
	LPDATAOBJECT lpdobj, HKEY hkeyProgID)
{
	if (lpdobj == NULL)
		return E_INVALIDARG;
	wchar_t soubor[MAX_PATH];
	STGMEDIUM medium;
	FORMATETC fe = {CF_HDROP, NULL,
		DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
	HRESULT hr = lpdobj->GetData(&fe, &medium);
	if (FAILED(hr))
		return E_INVALIDARG;
	UINT pocet = 
		DragQueryFile(reinterpret_cast<HDROP>(medium.hGlobal),
			0xFFFFFFFF, NULL, MAX_PATH);
	soubory.RemoveAll();
	for (int i = 0; i < (int)pocet; i++)
	{
		DragQueryFile(reinterpret_cast<HDROP>(medium.hGlobal),
			i, soubor, MAX_PATH);
		soubory.Add(CString(soubor));
	}
	ReleaseStgMedium(&medium);
	return hr;
}

STDMETHOD(QueryContextMenu)(HMENU hmenu, UINT indexMenu,
	UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
{
	if (!(CMF_DEFAULTONLY & uFlags))
	{
		InsertMenu(hmenu, indexMenu++, MF_STRING | MF_BYPOSITION,
			idCmdFirst, L"Promtnout obrzek(-y)");
		return MAKE_HRESULT(SEVERITY_SUCCESS, FACILITY_NULL, 1);
	}
	return MAKE_HRESULT(SEVERITY_SUCCESS, FACILITY_NULL, USHORT(0));
}

STDMETHOD(GetCommandString)(UINT idCmd,	UINT uFlags,
	UINT *pwReserved, LPSTR pszName, UINT cchMax)
{
	if (uFlags & GCS_HELPTEXT)
	{
		switch (idCmd)
		{
		case 0:
			if (uFlags & GCS_VERBW)
				lstrcpyn((wchar_t*)pszName,
				L"Promtne vybran obrzek/obrzky", cchMax);
			break;
		}
		return S_OK;
	}
	return E_FAIL;
}

STDMETHOD(InvokeCommand)(LPCMINVOKECOMMANDINFO pici)
{
	wchar_t szCesta[MAX_PATH+100];
	STARTUPINFO si; 
	PROCESS_INFORMATION pi; 

	UINT idOffset = LOWORD(pici->lpVerb);
	CString strParametry;
	CString soubor;
	switch (idOffset)
	{	
	case 0:
		if (GetModuleFileNameW(GetModuleHandle(L"PromitaniObrazku.dll"),
			szCesta, MAX_PATH) == 0)
			break;
		if (!PathRemoveFileSpecW(szCesta))
			break;
		memset(&si, 0, sizeof(si)); 
		memset(&pi, 0, sizeof(pi)); 
		si.cb = sizeof(STARTUPINFO); 
		si.dwFlags = STARTF_USESHOWWINDOW;
		si.wShowWindow = SW_SHOW;
		strParametry = CString(L" ");
		for (int i = 0; i < (int)soubory.GetCount(); i++)
		{
			soubor = soubory.GetAt(i);
			strParametry.Append(L" \"");
			strParametry.Append(soubor);
			strParametry.Append(L"\"");
		}
		wcscat_s(szCesta, _countof(szCesta), L"\\PromitaniObrazku.exe");
		if (CreateProcess(szCesta,
			strParametry.GetBuffer(),
			NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi) )
		{ 
			CloseHandle(pi.hProcess); 
			CloseHandle(pi.hThread); 
		}
		break;
	}
	return S_OK;
}

};

OBJECT_ENTRY_AUTO(__uuidof(PromitaniObrazkuShellExt), Aplikace)
