/****************************************************
Soubor: OknoHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoHlavni : public CWindowImpl< OknoHlavni >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)NULL,
				(HCURSOR)NULL,
				(HBRUSH)NULL,
				NULL, // menu
				_aplikace.tridaHlavni,
				(HICON)NULL
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

public:
	Bitmap* bitmap;
	HBRUSH hbrushPozadi;
	int indexSouboru;
	bool timerSpusten;

public:
	OknoHlavni()
	{
		this->bitmap = NULL;
		this->indexSouboru = -1;
		this->timerSpusten = false;
	}

public:
	~OknoHlavni()
	{
		if (hbrushPozadi)
			DeleteObject(hbrushPozadi);
	}

	BEGIN_MSG_MAP(OknoHlavni)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_KEYUP, OnKeyUp)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_TIMER, OnTimer)
	END_MSG_MAP()


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	ZastavitTimer();
	ShowCursor(TRUE);
	return DefWindowProc();
}

void Vytvorit()
{
	hbrushPozadi = CreateSolidBrush(
		_aplikace.nastaveni.barvaPozadi);
	RECT rect = {0, 0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN)};
	if (!Create(NULL, rect, NULL,
		WS_POPUP, 0/*WS_EX_TOPMOST*/))
		AtlThrowLastWin32();
	PostMessage(WM_TIMER, 1);
	SpustitTimer();
	ShowCursor(FALSE);
	ShowWindow(SW_SHOW);
}


LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);

	HDC hdcPamet = CreateCompatibleDC(0);
	HBITMAP hBitmapPamet =
		CreateCompatibleBitmap(hdc,
		rect.right, rect.bottom);
	SelectObject(hdcPamet, hBitmapPamet);
	FillRect(hdcPamet, &rect, hbrushPozadi);

	Graphics* graphics = new Graphics(hdcPamet);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);
	delete graphics;
	BitBlt(hdc,
		0,	0,
		rect.right, rect.bottom,
		hdcPamet,
		0, 0, SRCCOPY);
	EndPaint(&ps);
	DeleteDC(hdcPamet);
	DeleteObject(hBitmapPamet);
	return 0;
}

LRESULT OnTimer(UINT, WPARAM, LPARAM, BOOL&)
{
	this->indexSouboru++;
	if (this->indexSouboru >= (int)_aplikace.soubory.GetCount())
	{
		if (_aplikace.nastaveni.cyklickyOpakovat)
			this->indexSouboru = 0;
		else
		{
			PostMessage(WM_CLOSE);
			return 0;
		}
	}
	CString soubor = (CString)
		_aplikace.soubory.GetAt(this->indexSouboru);
	if (this->bitmap)
		delete this->bitmap;
	this->bitmap = new Bitmap(soubor);
	RedrawWindow();
	return 0;
}

LRESULT OnKeyUp(UINT, WPARAM wParam, LPARAM, BOOL&)
{
	switch (wParam)
	{
	case VK_ESCAPE:
		PostMessage(WM_CLOSE);
		break;
	case VK_DOWN:
	case VK_RIGHT:
		ZastavitTimer();
		PostMessage(WM_TIMER, 1);
		SpustitTimer();
		break;
	case VK_LEFT:
	case VK_UP:
		if (this->indexSouboru > 0)
		{
			ZastavitTimer();
			this->indexSouboru -= 2;
			PostMessage(WM_TIMER, 1);
			SpustitTimer();
		}
	case VK_PAUSE:
		if (this->timerSpusten)
			ZastavitTimer();
		else
			SpustitTimer();
		break;
		break;
	}
	return DefWindowProc();
}

void ZastavitTimer()
{
	if (this->timerSpusten)
	{
		if (!KillTimer(1))
			_aplikace.FatalniChyba();
		this->timerSpusten = false;
	}
}


void SpustitTimer()
{
	if (!this->timerSpusten)
	{
		if (!SetTimer(1, 
			_aplikace.nastaveni.interval * 1000))
			_aplikace.FatalniChyba();
		this->timerSpusten = true;
	}
}

};

extern OknoHlavni _oknoHlavni;