/****************************************************
Soubor: DlgNastaveni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class DlgNastaveni : public CDialogImpl< DlgNastaveni >
{
public:
	enum { IDD = IDD_NASTAVENI };

public:
	~DlgNastaveni()
	{
	}
public:
	BEGIN_MSG_MAP(DlgNastaveni)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnOK)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnStorno)
		COMMAND_HANDLER(IDC_BARVA_POZADI,
			BN_CLICKED, OnBarvaPozadi)
			MESSAGE_HANDLER(WM_DRAWITEM, OnDrawItem)
	END_MSG_MAP()


LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	SetIcon(_aplikace.hicon, TRUE);
	SetIcon(_aplikace.hiconMala, FALSE);
	CString text;
	text.LoadString(IDS_PROJNAME);
	text.Append(L" - Nastaven");
	SetWindowText(text);
	SetDlgItemInt(IDC_INTERVAL, _aplikace.nastaveni.interval);
	if (_aplikace.nastaveni.cyklickyOpakovat)
		CheckDlgButton(IDC_CYKLICKY_OPAKOVAT, BST_CHECKED);
	return 1;
}

LRESULT OnOK(WORD, WORD wID, HWND, BOOL&)
{
	BOOL bOK;
	UINT cislo = GetDlgItemInt(IDC_INTERVAL, &bOK, FALSE);
	if (bOK && cislo > 0 && cislo < 1000)
		_aplikace.nastaveni.interval = cislo;
	_aplikace.nastaveni.cyklickyOpakovat =
		IsDlgButtonChecked(IDC_CYKLICKY_OPAKOVAT) == BST_CHECKED;
	_aplikace.ZapsatNastaveni();
	EndDialog(wID);
	return 0;
}

LRESULT OnStorno(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}

LRESULT OnBarvaPozadi(WORD, WORD wID, HWND, BOOL&)
{
		CHOOSECOLOR cc;
		static COLORREF crVychozi[16] = 
		{
			0x00000000,
			0x00FFFFFF,
			0x00FF0000,
			0x0000FF00,
			0x000000FF,
			0x00FF00FF,
			0x00FFFF00,
			0x0000FFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
		};
		memset(&cc, 0, sizeof(cc));
		cc.lStructSize = sizeof(cc);
		cc.lpCustColors = crVychozi;
		cc.hwndOwner = m_hWnd;
		cc.rgbResult = _aplikace.nastaveni.barvaPozadi;
		cc.Flags = CC_FULLOPEN | CC_RGBINIT;
		if (!ChooseColor(&cc))
			return 0;
		_aplikace.nastaveni.barvaPozadi = cc.rgbResult;
		RedrawWindow();
	return 0;
}

public:
	LRESULT OnDrawItem(UINT, WPARAM, LPARAM lParam, BOOL&)
	{
		if (((DRAWITEMSTRUCT*)lParam)->CtlID != IDC_UKAZKA_BARVY)
			return DefWindowProc();
		HBRUSH hbrush = CreateSolidBrush(_aplikace.nastaveni.barvaPozadi);
		if (!hbrush)
			_aplikace.FatalniChyba();
		FillRect(((DRAWITEMSTRUCT*)lParam)->hDC,
			&((DRAWITEMSTRUCT*)lParam)->rcItem,
			hbrush);

		if (!DeleteObject(hbrush))
			_aplikace.FatalniChyba();
		return DefWindowProc();
	}
};
