/****************************************************
Soubor: Aplikace.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"
#include "Registry.h"

struct Nastaveni
{
	DWORD interval;
	DWORD barvaPozadi;
	DWORD cyklickyOpakovat;
};

class Aplikace : public CAtlExeModuleT< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)
public:
	const wchar_t* registryKlic;
	const wchar_t* tridaHlavni;
public:
	HICON hicon;
	HICON hiconMala;
	ULONG_PTR gdiplusToken;
	Nastaveni nastaveni;
	CAtlArray<CString> soubory;
	CString jmeno;
public:
	HRESULT PreMessageLoop(int nShowCmd);
public:
	HRESULT PostMessageLoop();

public:
	Aplikace()
	{
		this->gdiplusToken = 0;
		this->hicon = NULL;
		this->hiconMala = NULL;
		registryKlic = L"Software\\Radek Chalupa\\Demo\\Promitani obrazku";
		tridaHlavni = L"PromitaniObrazku";
	}

	~Aplikace()
	{
		if (this->hicon)
		{
			DestroyIcon(this->hicon);
			this->hicon = NULL;
		}
		if (this->hiconMala)
		{
			DestroyIcon(this->hiconMala);
			this->hiconMala = NULL;
		}
	}

void VychoziNastaveni()
{
	nastaveni.barvaPozadi = GetSysColor(COLOR_DESKTOP);
	nastaveni.interval = 5;
	nastaveni.cyklickyOpakovat = false;
}

void NacistNastaveni()
{
	Registry reg(registryKlic);
	reg.Otevrit();
	reg.NacistCislo(L"barvaPozadi", nastaveni.barvaPozadi);
	reg.NacistCislo(L"interval", nastaveni.interval);
	reg.NacistCislo(L"cyklickyOpakovat", nastaveni.cyklickyOpakovat);
	reg.Zavrit();
}

void ZapsatNastaveni()
{
	Registry reg(registryKlic);
	reg.Otevrit();
	reg.ZapsatCislo(L"barvaPozadi", nastaveni.barvaPozadi);
	reg.ZapsatCislo(L"interval", nastaveni.interval);
	reg.ZapsatCislo(L"cyklickyOpakovat", nastaveni.cyklickyOpakovat);
	reg.Zavrit();
}

bool JeGrafickaPripona(wchar_t* pripona)
{
	if (_wcsicmp(pripona, L".jpg") == 0)
		return true;
	if (_wcsicmp(pripona, L".jpeg") == 0)
		return true;
	if (_wcsicmp(pripona, L".bmp") == 0)
		return true;
	if (_wcsicmp(pripona, L".png") == 0)
		return true;
	if (_wcsicmp(pripona, L".gif") == 0)
		return true;
	if (_wcsicmp(pripona, L".tiff") == 0)
		return true;
	return false;
}

void ZobrazitChybuWin32()
{
	DWORD chyba = GetLastError();
	if (chyba == 0) 
	{
		MessageBox(NULL, L"Dolo k nespecifikovan chyb",
			jmeno, MB_TASKMODAL | MB_SETFOREGROUND | MB_ICONERROR);
	}
	else
	{
		void* lpMessage = NULL;
		if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL, chyba,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
			(wchar_t*)&lpMessage, 0, NULL) == 0)
		{
			if (lpMessage)
				LocalFree(lpMessage);
			MessageBox(NULL, L"Dolo k nespecifikovan chyb",
				jmeno, MB_TASKMODAL | MB_SETFOREGROUND | MB_ICONERROR);
		}
		else
		{
			MessageBox(NULL, (wchar_t*)lpMessage, jmeno,
				MB_TASKMODAL | MB_SETFOREGROUND | MB_ICONERROR);
			LocalFree(lpMessage);
		}
	}
}

void FatalniChyba()
{
	ZobrazitChybuWin32();
	ExitProcess(-1);
}
};

extern Aplikace _aplikace;
