/****************************************************
Soubor: Aplikace.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "Aplikace.h"
#include "OknoHlavni.h"
#include "DlgNastaveni.h"

Aplikace _aplikace;


// Hlavn funkce programu pro Windows
extern "C" int WINAPI _tWinMain(HINSTANCE, HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}


HRESULT Aplikace::PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;
	if (!jmeno.LoadString(IDS_PROJNAME))
		return E_HANDLE;

	this->hicon = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR);
	if (!this->hicon)
		return E_HANDLE;
	this->hiconMala = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	if (!this->hiconMala)
		return E_HANDLE;

	try
	{
		VychoziNastaveni();
		NacistNastaveni();

		if (__argc <= 1)
		{
			DlgNastaveni dlg;
			dlg.DoModal();
			return S_FALSE;
		}
		for (int i = 1; i < __argc; i++)
		{
			if (JeGrafickaPripona(PathFindExtensionW(__wargv[i])))
			{
				this->soubory.Add(CString(__wargv[i]));
			}
		}

		GdiplusStartupInput gdiplusStartupInput;
		if (GdiplusStartup(&gdiplusToken,
			&gdiplusStartupInput, NULL) != Ok)
			return E_FAIL;

		_oknoHlavni.Vytvorit();
		return S_OK;
	}
	catch (CAtlException)
	{
		return E_FAIL;
	}

}

HRESULT Aplikace::PostMessageLoop()
{
	ShowCursor(TRUE);
	if (gdiplusToken != 0)
	{
		GdiplusShutdown(gdiplusToken);
		gdiplusToken = 0;
	}
	if (this->hicon)
	{
		DestroyIcon(this->hicon);
		this->hicon = NULL;
	}
	if (this->hiconMala)
	{
		DestroyIcon(this->hiconMala);
		this->hiconMala = NULL;
	}
	Unlock();
	return CAtlExeModuleT<Aplikace>::PostMessageLoop();
}
