/****************************************************
Soubor: Aplikace.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"UkazovaAplikace",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

public:
	ULONG_PTR gdiplusToken;
	CString jmeno;

	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
	END_MSG_MAP()

public:
	HRESULT PreMessageLoop(int nShowCmd)
	{
		CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
		Lock();
		INITCOMMONCONTROLSEX icc;
		icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
		icc.dwICC = ICC_WIN95_CLASSES |
			ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
			ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
			ICC_NATIVEFNTCTL_CLASS |
			ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
		if (!InitCommonControlsEx(&icc))
			return E_FAIL;

		jmeno.LoadString(IDS_PROJNAME);

		GdiplusStartupInput gdiplusStartupInput;
		if (GdiplusStartup(&gdiplusToken,
			&gdiplusStartupInput, NULL) != Ok)
			return E_FAIL;
		
		RECT rect = { 0, 0, 800, 600 };
		if (!Create(NULL, rect, jmeno, WS_OVERLAPPEDWINDOW, 0))
			return E_FAIL;
		CenterWindow();
		ShowWindow(SW_SHOW);
		return S_OK;
	}

public:
	HRESULT PostMessageLoop()
	{
		GdiplusShutdown(gdiplusToken);
		Unlock();
		return CAtlExeModuleT<Aplikace>::PostMessageLoop();
	}

	LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
	{
		PostQuitMessage(0);
		return DefWindowProc();
	}

	LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
	{
		PostMessage(WM_CLOSE);
		return 0;
	}
};

extern Aplikace _aplikace;
