/****************************************************
Soubor: ProhlizecFoto.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"UkazovaAplikace",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

public:
	ULONG_PTR gdiplusToken;
	CString jmeno;
	HBRUSH hbrushPozadi;
	wchar_t soubor[MAX_PATH];
	Bitmap* bitmap;

public:
	Aplikace();
	bool OtevritSoubor(const wchar_t* soubor);
	void ZavritSoubor();

	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBkgnd)
		MESSAGE_HANDLER(WM_DROPFILES, OnDropFiles)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_ZAVRIT, OnZavrit)
	END_MSG_MAP()

	HRESULT PreMessageLoop(int nShowCmd);
	HRESULT PostMessageLoop();
	LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnDropFiles(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnKonec(WORD, WORD, HWND, BOOL&);
	LRESULT OnZavrit(WORD, WORD, HWND, BOOL&);
	LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&);
	LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&);
	LRESULT OnEraseBkgnd(UINT, WPARAM, LPARAM, BOOL&);
};

extern Aplikace _aplikace;
