/****************************************************
Soubor: ProhlizecFoto.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "ProhlizecFoto.h"

Aplikace _aplikace;

extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}

Aplikace::Aplikace()
{
	bitmap = NULL;
	wcscpy_s(soubor, _countof(soubor), L"");
}

HRESULT Aplikace::PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	
	RECT rect = { 0, 0, 800, 600 };
	if (!Create(NULL, rect, jmeno, WS_OVERLAPPEDWINDOW, 0))
		return E_FAIL;
	DragAcceptFiles(TRUE);
	hbrushPozadi = CreatePatternBrush(
		LoadBitmap(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDB_POZADI)));
	CenterWindow();
	ShowWindow(SW_SHOW);
	return S_OK;
}

HRESULT Aplikace::PostMessageLoop()
{
	if (hbrushPozadi)
	{
		DeleteObject(hbrushPozadi);
		hbrushPozadi = NULL;
	}
	ZavritSoubor();
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return CAtlExeModuleT<Aplikace>::PostMessageLoop();
}

LRESULT Aplikace::OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT Aplikace::OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	ZavritSoubor();
	return DefWindowProc();
}

LRESULT Aplikace::OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT Aplikace::OnZavrit(WORD, WORD, HWND, BOOL&)
{
	ZavritSoubor();
	RedrawWindow();
	return 0;
}

LRESULT Aplikace::OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	OtevritSoubor(this->soubor);
	return 0;
}

void Aplikace::ZavritSoubor()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

bool Aplikace::OtevritSoubor(const wchar_t* soubor)
{
	ZavritSoubor();
	this->bitmap = new Bitmap(soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		return false;
	}
	else
	{
		wcscpy_s(this->soubor,
			_countof(this->soubor),	soubor);
		RedrawWindow();
		return true;
	}
}

LRESULT Aplikace::OnEraseBkgnd(UINT, WPARAM, LPARAM, BOOL&)
{
	return 0;
}

LRESULT Aplikace::OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	HDC hdcPamet = CreateCompatibleDC(0);
	HBITMAP hBitmapPamet =
		CreateCompatibleBitmap(hdc,
		rect.right, rect.bottom);
	SelectObject(hdcPamet, hBitmapPamet);
	FillRect(hdcPamet, &rect, hbrushPozadi);
	if (this->bitmap)
	{
		UINT sirka = rect.right;
		UINT vyska = rect.bottom;
		int xPoz = 0;
		int yPoz = 0;
		// Zda bitmapa pesahuje alespo v jednom
		// rozmru velikost kl. oblasti okna
		if ((UINT)sirka < bitmap->GetWidth() ||
			(UINT)vyska < bitmap->GetHeight())
		{
			if ((float)sirka/(float)bitmap->GetWidth() >
				(float)vyska/(float)bitmap->GetHeight())
			{
				sirka = (bitmap->GetWidth()*vyska ) /
					bitmap->GetHeight();
				xPoz = (rect.right - sirka) / 2;
			}
			else
			{
				vyska = (bitmap->GetHeight()*sirka ) /
					bitmap->GetWidth();
				yPoz = (rect.bottom - vyska) / 2;
			}
		}
		else
		{
			sirka = this->bitmap->GetWidth();
			vyska = this->bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
			yPoz = (rect.bottom - vyska) / 2;
		}
		Graphics* graphics = new Graphics(hdcPamet);
		Rect rectCil(xPoz, yPoz, sirka, vyska);
		graphics->DrawImage(bitmap,
			rectCil,
			0, 0,
			bitmap->GetWidth(),
			bitmap->GetHeight(),
			UnitPixel);
		delete graphics;
	}
	BitBlt(hdc,
		0,	0,
		rect.right, rect.bottom,
		hdcPamet,
		0, 0, SRCCOPY);

	SelectObject(hdcPamet, NULL);
	EndPaint(&ps);
	DeleteDC(hdcPamet);
	DeleteObject(hBitmapPamet);
	return 0;
}


LRESULT Aplikace::OnDropFiles(UINT,
	WPARAM wParam, LPARAM, BOOL&)
{
	wchar_t soubor[MAX_PATH];
	int Pocet = (int)DragQueryFile(
		(HDROP)wParam, 0xFFFFFFFF, NULL, 0);
	if (Pocet <= 0)
		return 0;
	DragQueryFile((HDROP)wParam, 0, soubor, MAX_PATH);
	OtevritSoubor(soubor);
	DragFinish((HDROP)wParam);
	return 0;
}
