/****************************************************
Soubor: ParametryKodeku.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include <strsafe.h>

void TypHodnoty(ULONG index, wchar_t* typHodnoty, UINT maxZnaku);
void KategoriePodleGuid(GUID guid, wchar_t* kategorie, UINT maxZnaku);


VOID ShowAllEncoderParameters(ImageCodecInfo* pImageCodecInfo)
{
	const int maxDelkaKategorie = 50;
	const int maxDelkaTypu = 50;
	wchar_t szKategorie[maxDelkaKategorie] = L"";
	wchar_t szTypHodnoty[maxDelkaTypu] = L"";

	wprintf(L"\n\n%s\n", pImageCodecInfo->MimeType);

	Bitmap bitmap(1, 1);

	UINT velikost = 0; 
	velikost = bitmap.GetEncoderParameterListSize(&pImageCodecInfo->Clsid);
	wprintf(L"Seznam parametr vyaduje %d byt.\n", velikost);

	if (velikost == 0)
		return;

	EncoderParameters* pEncoderParameters = NULL;
	pEncoderParameters = (EncoderParameters*)malloc(velikost);

	if (pEncoderParameters == NULL)
		return;

	bitmap.GetEncoderParameterList(&pImageCodecInfo->Clsid,
		velikost, pEncoderParameters);

	printf("V poli je %d objekt.\n", pEncoderParameters->Count);

	for (UINT i = 0; i < pEncoderParameters->Count; i++)
	{
		KategoriePodleGuid(
			pEncoderParameters->Parameter[i].Guid,
			szKategorie, maxDelkaKategorie);

		TypHodnoty(pEncoderParameters->Parameter[i].Type,
			szTypHodnoty, maxDelkaTypu);

		wprintf(L"Parametr[%d]\n", i);
		wprintf(L"Kategorie: %s.\n", szKategorie);
		wprintf(L"Typ dat: %s.\n", szTypHodnoty);

		printf("Poet hodnot: %d.\n",
		pEncoderParameters->Parameter[i].NumberOfValues); 
	}

	free(pEncoderParameters);
}


void KategoriePodleGuid(GUID guid, wchar_t* kategorie, UINT maxZnaku)
{
	if (guid == EncoderCompression)
		wcscpy_s(kategorie, maxZnaku, L"Komprese");
	else if(guid == EncoderColorDepth)
		wcscpy_s(kategorie, maxZnaku, L"Barevn hloubka");
	else if(guid == EncoderScanMethod)
		wcscpy_s(kategorie, maxZnaku, L"Zpsob skenovn");
	else if(guid == EncoderVersion)
		wcscpy_s(kategorie, maxZnaku, L"Verze");
	else if(guid == EncoderRenderMethod)
		wcscpy_s(kategorie, maxZnaku, L"Zpsob renderovn");
	else if(guid == EncoderQuality)
		wcscpy_s(kategorie, maxZnaku, L"Kvalita");
	else if(guid == EncoderTransformation)
		wcscpy_s(kategorie, maxZnaku, L"Transformace");
	else if(guid == EncoderLuminanceTable)
		wcscpy_s(kategorie, maxZnaku, L"Luminance");
	else if(guid == EncoderChrominanceTable)
		wcscpy_s(kategorie, maxZnaku, L"TabulkaBarev");
	else if(guid == EncoderSaveFlag)
		wcscpy_s(kategorie, maxZnaku, L"Pznak uloen");
	else
		wcscpy_s(kategorie, maxZnaku, L"Neznm kategorie");
}


void TypHodnoty(ULONG index, wchar_t* typHodnoty, UINT maxZnaku)
{
   wchar_t* valueTypes[] = {
      L"dn",           // 0
      L"Byte",            // 1
      L"ASCII",           // 2
      L"Short",           // 3
      L"Long",            // 4
      L"Rational",        // 5
      L"LongRange",       // 6
      L"Nedefinovan",    // 7
      L"RationalRange"};  // 8
   wcscpy_s(typHodnoty, maxZnaku, valueTypes[index]);
}

int _tmain(int argc, _TCHAR* argv[])
{
	_wsetlocale(LC_ALL, L"Czech");
	ULONG_PTR gdiplusToken;
	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL) != Ok)
	{
		wprintf(L"Nepodailo se inicializovat knihovnu GDI+\n");
		return 1;
	}

	ImageCodecInfo* pImageCodecInfo;

	UINT pocet;
	UINT velikost;
	GetImageEncodersSize(&pocet, &velikost);

	// Create a buffer large enough to hold the array of ImageCodecInfo
	// objects that will be returned by GetImageEncoders.
	pImageCodecInfo = (ImageCodecInfo*)malloc(velikost);

	// GetImageEncoders creates an array of ImageCodecInfo objects
	// and copies that array into a previously allocated buffer. 
	// The third argument, imageCodecInfos, is a pointer to that buffer. 
	GetImageEncoders(pocet, velikost, pImageCodecInfo);

	// For each ImageCodecInfo object in the array, show all parameters.
	for (UINT i = 0; i < pocet; i++)
	{ 
		ShowAllEncoderParameters(&(pImageCodecInfo[i]));
	}

		
	GdiplusShutdown(gdiplusToken);
	getchar();
	return 0;
}

