/****************************************************
Soubor: DlgHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class DlgHlavni : public CDialogImpl< DlgHlavni >
{
public:
	enum { IDD = IDD_HLAVNI };

public:
	~DlgHlavni()
	{
	}

public:
	BEGIN_MSG_MAP(DlgHlavni)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnZavrit)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnZavrit)
		COMMAND_HANDLER(IDC_PREPNOUT_VYBRANY,
			BN_CLICKED, OnPrepnoutVybrany)
		COMMAND_HANDLER(IDC_POUZE_PODPOROVANE,
			BN_CLICKED, OnPouzePodporovane)
	END_MSG_MAP()


LRESULT OnInitDialog(UINT uMsg, WPARAM wParam,
	LPARAM lParam, BOOL& bHandled)
{
	CString text;
	text.LoadString(IDS_PROJNAME);
	SetWindowText(text);
	SetIcon(LoadIcon(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDI_HLAVNI)), TRUE);
	SetIcon(LoadIcon(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDI_HLAVNI)), FALSE);
	NaplnitSeznamRezimu(false);
	CheckDlgButton(IDC_POUZE_PODPOROVANE, BST_CHECKED);
	VytvoritTextAktualniRezim(text);
	SetDlgItemText(IDC_AKTUALNI_NASTAVENI, text);
	return 1;
}


LRESULT OnZavrit(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}

void VytvoritTextAktualniRezim(CString& text)
{
	HDC hDC = ::GetDC(NULL);
	int freq;
	
	text.Format(L"%d x %d, ",
		GetDeviceCaps(hDC, HORZRES),
		GetDeviceCaps(hDC, VERTRES));
	
	switch (GetDeviceCaps(hDC, BITSPIXEL))
	{
	case 2:
		text += L"mono";
		break;
	case 4:
		text += L"16 barev";
		break;
	case 8:
		text += L"256 barev";
		break;
	case 16:
		text += L"Hi-color (16 bit)";
		break;
	case 24:
	case 32:
		text += L"True color (24/32 bit)";
		break;
	default:
		break;
	}
	freq = GetDeviceCaps(hDC, VREFRESH);
	if (freq > 0)
		text.AppendFormat(L", %d Hz", freq);
	
	if (!::ReleaseDC(NULL, hDC))
		AtlThrowLastWin32();
}

void VytvoritTextRezimu(DEVMODE devmode, CString& text)
{
	wchar_t szLine[255];
	wchar_t szText[100];
	_itow_s(devmode.dmPelsWidth, szLine, _countof(szLine), 10);
	wcscat_s(szLine, _countof(szLine), L" x ");
	_itow_s(devmode.dmPelsHeight, szText, _countof(szText), 10);
	wcscat_s(szLine, _countof(szLine), szText);
	switch (devmode.dmBitsPerPel)
	{
	case 2:
		wcscpy_s(szText, _countof(szText), L"mono");
		break;
	case 4:
		wcscpy_s(szText, _countof(szText), L"16 barev");
		break;
	case 8:
		wcscpy_s(szText, _countof(szText), L"256 barev");
		break;
	case 16:
		wcscpy_s(szText, _countof(szText), L"Hi-color (16 bit)");
		break;
	case 32:
		wcscpy_s(szText, _countof(szText), L"True color (32 bit)");
		break;
	default:
		_itow_s(devmode.dmBitsPerPel, szText, _countof(szText), 10);
		break;
	}
	if (devmode.dmDisplayFrequency > 0)
	{
		wcscat_s(szLine, _countof(szLine), L", ");
		wcscat_s(szLine, _countof(szLine), szText);
		wcscat_s(szLine, _countof(szLine), L", ");
		_itow_s(devmode.dmDisplayFrequency, szText,
			_countof(szText), 10);
		wcscat_s(szLine, _countof(szLine), szText);
		wcscat_s(szLine, _countof(szLine), L" Hz");
	}
	text = CString(szLine);
}

void NaplnitSeznamRezimu(bool vsechny)
{
	CWindow lbSeznam;
	lbSeznam.Attach(GetDlgItem(IDC_SEZNAM_REZIMU));
	lbSeznam.SendMessage(LB_RESETCONTENT);

	CString text;
	DWORD dwMode = 0;
	BOOL bResult = TRUE;
	DEVMODE devmode;
	memset(&devmode, 0, sizeof(DEVMODE));
	devmode.dmSize = sizeof(DEVMODE);
	devmode.dmDriverExtra = 0;
	LRESULT lresult;
	while (bResult)
	{
		bResult = EnumDisplaySettingsEx(NULL, dwMode, &devmode,
			vsechny ? EDS_RAWMODE : 0);
		VytvoritTextRezimu(devmode, text);
		lresult = lbSeznam.SendMessage(LB_ADDSTRING, 0,
			(LPARAM)text.GetBuffer());
		lbSeznam.SendMessage(LB_SETITEMDATA, lresult,
			(LPARAM)dwMode);
		dwMode++;
	}
	if (dwMode > 0)
		lbSeznam.SendMessage(LB_SETCURSEL, 0);
	if (vsechny)
		text.Format(L"Vechny reimy graf. karty - poet: %d",
		(int)lbSeznam.SendMessage(LB_GETCOUNT));
	else
		text.Format(L"Reimy podporovan monitorem - poet: %d",
		(int)lbSeznam.SendMessage(LB_GETCOUNT));
	SetDlgItemText(IDC_POCET_REZIMU, text);
}


LRESULT OnPrepnoutVybrany(WORD, WORD wID, HWND, BOOL&)
{
	DWORD rezim = (DWORD)SendDlgItemMessage(
		IDC_SEZNAM_REZIMU, LB_GETCURSEL);
	DEVMODE devmode;
	memset(&devmode, 0, sizeof(DEVMODE));
	devmode.dmSize = sizeof(DEVMODE);
	if (!EnumDisplaySettings(NULL, rezim, &devmode ))
		return 0; // nc je patn, jdeme pry...

	devmode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT |
		DM_BITSPERPEL | DM_DISPLAYFREQUENCY;
	ChangeDisplaySettings(&devmode, CDS_UPDATEREGISTRY);
	return 0;
}

LRESULT OnPouzePodporovane(WORD, WORD, HWND, BOOL&)
{
	NaplnitSeznamRezimu(IsDlgButtonChecked(
		IDC_POUZE_PODPOROVANE) != BST_CHECKED);
	return 0;
}
};

extern DlgHlavni* _dlgHlavni;