/****************************************************
Soubor: Aplikace.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"
#include "DlgHlavni.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public :
	DECLARE_LIBID(LIBID_ATLLib)

	static const UINT wmOznamovaciIkona = WM_APP + 1;

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)NULL,
				NULL, // menu
				L"OvladaniObrazovky",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

public:
	CString jmeno;

BEGIN_MSG_MAP(Aplikace)
	MESSAGE_HANDLER(WM_CLOSE, OnClose)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	MESSAGE_HANDLER(WM_SYSCOMMAND, OnSysCommand)
	MESSAGE_HANDLER(Aplikace::wmOznamovaciIkona,
		OnOznamovaciIkona)
	COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
	COMMAND_ID_HANDLER(ID_SPORIC, OnSporic)
	COMMAND_ID_HANDLER(ID_POVOLIT_SPORIC, OnPovolitSporic)
	COMMAND_ID_HANDLER(ID_USPORNY_REZIM, OnUspornyRezim)
	COMMAND_ID_HANDLER(ID_POVOLIT_USPORNY_REZIM,
		OnPovolitUspornyRezim)
	COMMAND_ID_HANDLER(ID_ZOBRAZIT_OKNO, OnZobrazitOkno)
END_MSG_MAP()


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}


LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	ZrusitOznamovaciIkonu();
	return DefWindowProc();
}

LRESULT OnSysCommand(UINT uMsg, WPARAM wParam,
	LPARAM lParam, BOOL& bHandled)
{
	switch (wParam)
	{
	case SC_MINIMIZE:
		DefWindowProc();
		ShowWindow(SW_HIDE);
		return 0;
		break;
	}
	return DefWindowProc();
}


HRESULT PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
	Lock();

	try
	{
		INITCOMMONCONTROLSEX icc;
		icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
		icc.dwICC = ICC_WIN95_CLASSES |
			ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
			ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
			ICC_NATIVEFNTCTL_CLASS |
			ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
		if (!InitCommonControlsEx(&icc))
			AtlThrowLastWin32();

		jmeno.LoadString(IDS_PROJNAME);

		RECT rect = { 0, 0, 0, 0 };
		if (!Create(NULL, rect, jmeno,
			WS_POPUP, WS_EX_TOOLWINDOW))
			AtlThrowLastWin32();

		SendMessage(WM_SYSCOMMAND, SC_MINIMIZE);
		VytvoritOznamovaciIkonu();
		return S_OK;
	}
	catch (CAtlException)
	{
		return E_FAIL;
	}

}

void VytvoritOznamovaciIkonu()
{
	NOTIFYICONDATA nid;
	memset(&nid, 0, sizeof(NOTIFYICONDATA));
	nid.cbSize = sizeof(NOTIFYICONDATA);
	nid.hIcon = (HICON)SendMessage(WM_GETICON, ICON_SMALL, 0);
#pragma warning(push)
#pragma warning(disable: 4312)
	if (!nid.hIcon)
		nid.hIcon = (HICON)::GetClassLongPtr(m_hWnd, GCLP_HICONSM);
#pragma warning(pop)
	nid.hWnd = m_hWnd;
	nid.uCallbackMessage = Aplikace::wmOznamovaciIkona;
	GetWindowText(nid.szTip, _countof(nid.szTip));
	nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	nid.uID = 1;
	if (!Shell_NotifyIcon(NIM_ADD, &nid))
		AtlThrowLastWin32();
}


void ZrusitOznamovaciIkonu()
{
	NOTIFYICONDATA nid;
	memset(&nid, 0, sizeof(NOTIFYICONDATA));
	nid.cbSize = sizeof(NOTIFYICONDATA);
	nid.hWnd = m_hWnd;
	nid.uID = 1;
	if (!Shell_NotifyIcon(NIM_DELETE, &nid))
		AtlThrowLastWin32();
}


HRESULT PostMessageLoop()
{
	Unlock();
	return __super::PostMessageLoop();
}


void SpustitPopupMenu()
{
	POINT point;
	if (!GetCursorPos(&point))
		AtlThrowLastWin32();
	HMENU hMenu = LoadMenu(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDR_HLAVNI));

	if (SporicPovolen())
		CheckMenuItem(hMenu, ID_POVOLIT_SPORIC,
		MF_CHECKED | MF_BYCOMMAND);
	else
		EnableMenuItem(hMenu, ID_SPORIC,
		MF_DISABLED | MF_GRAYED | MF_BYCOMMAND);

	if (UspornyRezimPovolen())
		CheckMenuItem(hMenu, ID_POVOLIT_USPORNY_REZIM,
		MF_CHECKED | MF_BYCOMMAND);
	else
		EnableMenuItem(hMenu, ID_USPORNY_REZIM,
		MF_DISABLED | MF_GRAYED | MF_BYCOMMAND);

	::SetForegroundWindow(m_hWnd);
	if (!TrackPopupMenu(GetSubMenu(hMenu, 0),
		TPM_LEFTALIGN | TPM_TOPALIGN | TPM_RIGHTBUTTON,
			point.x, point.y, 0, m_hWnd, NULL))
			AtlThrowLastWin32();
	if (!DestroyMenu(hMenu))
		AtlThrowLastWin32();
}

LRESULT OnOznamovaciIkona(UINT, WPARAM wParam,
	LPARAM lParam, BOOL&)
{
	switch (wParam)
	{
	case 1:
		switch (lParam)
		{
		case WM_LBUTTONUP:
		case WM_MBUTTONUP:
		case WM_RBUTTONUP:
			SpustitPopupMenu();
			break;
		}
		break;
	}
	return 0;
}

LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT OnSporic(WORD, WORD, HWND, BOOL&)
{
	Sleep(400);
	::PostMessage(HWND_BROADCAST,
		WM_SYSCOMMAND, SC_SCREENSAVE, 0);
	return 0;
}

LRESULT OnPovolitSporic(WORD, WORD, HWND, BOOL&)
{
	PovolitSporicObrazovky(!SporicPovolen());
	return 0;
}

LRESULT OnUspornyRezim(WORD, WORD, HWND, BOOL&)
{
	Sleep(400);
	::PostMessage(HWND_BROADCAST,
		WM_SYSCOMMAND, SC_MONITORPOWER, 2);
	return 0;
}

LRESULT OnPovolitUspornyRezim(WORD, WORD, HWND, BOOL&)
{
	PovolitUspornyRezim(!UspornyRezimPovolen());
	return 0;
}

bool SporicPovolen()
{
	BOOL bAktivni;
	SystemParametersInfo(SPI_GETSCREENSAVEACTIVE,
		0, &bAktivni, 0);
	return (bAktivni != 0);
}

void PovolitSporicObrazovky(bool povolit)
{
	SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,
		povolit ? 1 : 0, NULL, 0);
}


void PovolitUspornyRezim(bool povolit)
{
	SystemParametersInfo(SPI_SETPOWEROFFACTIVE,
		povolit ? 1 : 0, NULL, 0);
}

bool UspornyRezimPovolen()
{
	BOOL bPovoleno;
	SystemParametersInfo(SPI_GETPOWEROFFACTIVE,
		0, &bPovoleno, 0);
	return (bPovoleno != 0);
}

LRESULT OnZobrazitOkno(WORD, WORD, HWND, BOOL&)
{
	if (!_dlgHlavni)
	{
		_dlgHlavni = new DlgHlavni();
		_dlgHlavni->DoModal(NULL);
		delete _dlgHlavni;
		_dlgHlavni = NULL;
	}
	else
	{
		::SetForegroundWindow(_dlgHlavni->m_hWnd);
	}
	return 0;
}

};

extern Aplikace _aplikace;