/****************************************************
Soubor: ObrazekInfo.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "ObrazekInfo.h"

Aplikace _aplikace;

//
extern "C" int WINAPI _tWinMain(HINSTANCE, HINSTANCE,
	LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}

Aplikace::Aplikace()
{
	bitmap = NULL;

}

HRESULT Aplikace::PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;
	ULONG_PTR gdiplusToken;
	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;

	DoModal();

	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	
	Unlock();
	return S_FALSE;
}

LRESULT Aplikace::OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	CString text;
	text.LoadString(IDS_PROJNAME);
	SetWindowText(text);
	wcscpy_s(this->soubor, _countof(this->soubor), L"");
	HICON hicon = LoadIcon(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDI_HLAVNI));
	SetIcon(hicon, TRUE);
	SetIcon(hicon, FALSE);
	return TRUE;
}

LRESULT Aplikace::OnKonec(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}

LRESULT Aplikace::OnOtevrit(WORD, WORD wID, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	if (this->bitmap)
		delete bitmap;

	this->bitmap = new Bitmap(this->soubor);
	if (this->bitmap->GetLastStatus() != Ok)
	{
		delete this->bitmap;
		this->bitmap = NULL;
		return 0;
	}

	CString text;
	SetDlgItemText(IDC_JMENO_SOUBORU,
		PathFindFileNameW(this->soubor));

	HANDLE hSoubor = CreateFile(this->soubor,
		0,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		0, NULL);
	wchar_t szVelikost[40];
	StrFormatByteSize(GetFileSize(hSoubor, NULL),szVelikost,
		sizeof(szVelikost) / sizeof(wchar_t));
	text.Format(L"Velikost: %s", szVelikost);
	SetDlgItemText(IDC_VELIKOST_SOUBORU, text);
	FILETIME ftVytvoreno;
	FILETIME ftOtevreno;
	FILETIME ftZapsano;
	SYSTEMTIME systemTime;
	SYSTEMTIME localTime;
	GetFileTime(hSoubor, &ftVytvoreno,
		&ftOtevreno, &ftZapsano);

	FileTimeToSystemTime(&ftVytvoreno, &systemTime);
	SystemTimeToTzSpecificLocalTime(NULL,
		&systemTime, &localTime);
	text.Format(L"Vytvoen: %d.%d.%d  %.2d:%d",
		localTime.wDay,
		localTime.wMonth,
		localTime.wYear,
		localTime.wHour,
		localTime.wMinute);
	SetDlgItemText(IDC_SOUBOR_VYTVOREN, text);

	FileTimeToSystemTime(&ftOtevreno, &systemTime);
	SystemTimeToTzSpecificLocalTime(NULL,
		&systemTime, &localTime);
	text.Format(L"Oteven: %d.%d.%d  %.2d:%d",
		localTime.wDay,
		localTime.wMonth,
		localTime.wYear,
		localTime.wHour,
		localTime.wMinute);
	SetDlgItemText(IDC_SOUBOR_OTEVREN, text);

	FileTimeToSystemTime(&ftZapsano, &systemTime);
	SystemTimeToTzSpecificLocalTime(NULL,
		&systemTime, &localTime);
	text.Format(L"Zmnn: %d.%d.%d  %.2d:%d",
		localTime.wDay,
		localTime.wMonth,
		localTime.wYear,
		localTime.wHour,
		localTime.wMinute);
	SetDlgItemText(IDC_SOUBOR_ZMENEN, text);

	CloseHandle(hSoubor);

	text.Format(L"Rozmry: %d x %d",
		(int)bitmap->GetWidth(), (int)bitmap->GetHeight());
	SetDlgItemText(IDC_ROZMERY, text);
	PixelFormat pf = bitmap->GetPixelFormat();
	text.Format(L"Barevn hloubka: %d bit",
		(int)((pf >> 8) & 0xFF));
	SetDlgItemText(IDC_BAREVNA_HLOUBKA, text);

	GUID guid;
	bitmap->GetRawFormat(&guid);

	if (guid == ImageFormatBMP)
		text = L"Bitmapa";
	if (guid == ImageFormatEMF)
		text = L"EMF - rozen metasoubor";
	if (guid == ImageFormatGIF)
		text = L"GIF";
	if (guid == ImageFormatIcon)
		text = L"Ikona";
	if (guid ==  ImageFormatJPEG)
		text = L"JPEG";
	if (guid == ImageFormatPNG)
		text = L"PNG";
	if (guid == ImageFormatTIFF)
		text = L"TIFF";
	if (guid == ImageFormatWMF)
		text = L"WMF - metasoubor";
	text.Insert(0, L"Formt: ");
	SetDlgItemText(IDC_RAW_FORMAT, text);

	text.Format(L"Rozlien: %d x %d bod na palec",
		(int)bitmap->GetHorizontalResolution(),
		(int)bitmap->GetVerticalResolution());
	SetDlgItemText(IDC_ROZLISENI, text);

	GetDlgItem(IDC_NAHLED).RedrawWindow();
	GetDlgItem(IDC_NAHLED).RedrawWindow();

	return 0;
}


LRESULT Aplikace::OnDrawItem(UINT, WPARAM, LPARAM lParam, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	if (((DRAWITEMSTRUCT*)lParam)->CtlID != IDC_NAHLED)
		return DefWindowProc();

	long xPoz = ((DRAWITEMSTRUCT*)lParam)->rcItem.left;
	long yPoz = ((DRAWITEMSTRUCT*)lParam)->rcItem.top;
	long sirka = ((DRAWITEMSTRUCT*)lParam)->rcItem.right -
		((DRAWITEMSTRUCT*)lParam)->rcItem.left;
	long vyska = ((DRAWITEMSTRUCT*)lParam)->rcItem.bottom -
		((DRAWITEMSTRUCT*)lParam)->rcItem.top;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
			sirka = (bitmap->GetWidth()*vyska ) /
			bitmap->GetHeight();
		else
			vyska = (bitmap->GetHeight()*sirka ) /
			bitmap->GetWidth();
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
	}
	Graphics graphics((HDC)((DRAWITEMSTRUCT*)lParam)->hDC);
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	return (graphics.DrawImage(
		bitmap->GetThumbnailImage(sirka, vyska, NULL, NULL),
		rectCil,
		0, 0,
		sirka,
		vyska,
		UnitPixel) == Ok);
	return 0;
}
