/****************************************************
Soubor: OknoHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoHlavni : public CWindowImpl < OknoHlavni >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"ZobrazeniObrazku",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	enum TypKresleni
	{
		podleOkna,
		cachedBitmap,
		normal,
		kvalita
	};

public:
	wchar_t soubor[MAX_PATH];
	Bitmap* bitmap;
	TypKresleni typKresleni;


public:
	OknoHlavni()
	{
		this->bitmap = NULL;
		this->typKresleni = kvalita;
	}

public:
	~OknoHlavni()
	{
		if (this->bitmap)
		{
			delete this->bitmap;
		}
	}

public:
	BEGIN_MSG_MAP(OknoHlavni)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_CACHED_BITMAP, OnZpusobZobrazeni)
		COMMAND_ID_HANDLER(ID_KVALITA, OnZpusobZobrazeni)
		COMMAND_ID_HANDLER(ID_NORMAL, OnZpusobZobrazeni)
		COMMAND_ID_HANDLER(ID_PODLE_OKNA, OnZpusobZobrazeni)
	END_MSG_MAP()

LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	ZavritSoubor();
	return DefWindowProc();
}

LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

void KreslitKvalita(Graphics* gr, RECT* rect)
{
#pragma warning(push)
#pragma warning(disable: 4244)
	const float pomer = (float)0.13;
	gr->SetInterpolationMode(InterpolationModeLowQuality);
	gr->DrawImage(bitmap,
		Rect(5, 5,
		pomer * bitmap->GetWidth(),
		pomer * bitmap->GetHeight()),
		0, 0,
		bitmap->GetWidth(), bitmap->GetHeight(),
		UnitPixel);
	gr->SetInterpolationMode(InterpolationModeNearestNeighbor);
	gr->DrawImage(bitmap,
		Rect(10 + pomer * bitmap->GetWidth(), 5,
		pomer * bitmap->GetWidth(),
		pomer * bitmap->GetHeight()),
		0, 0, bitmap->GetWidth(), bitmap->GetHeight(),
		UnitPixel);
	gr->SetInterpolationMode(InterpolationModeHighQualityBilinear);
	gr->DrawImage(bitmap,
		Rect(5, 10 + pomer*bitmap->GetHeight(),
		pomer * bitmap->GetWidth(),
		pomer * bitmap->GetHeight()),
		0, 0,
		bitmap->GetWidth(), bitmap->GetHeight(),
		UnitPixel);
	gr->SetInterpolationMode(InterpolationModeHighQualityBicubic);
	gr->DrawImage(bitmap,
		Rect(10 + pomer*bitmap->GetWidth(),
		10 + pomer * bitmap->GetHeight(),
		pomer * bitmap->GetWidth(),
		pomer * bitmap->GetHeight()),
		0, 0,
		bitmap->GetWidth(), bitmap->GetHeight(),
		UnitPixel);
#pragma warning(pop)
}


void KreslitCachedBitmap(Graphics* gr)
{
	CachedBitmap* cb;
	cb = new CachedBitmap(bitmap, gr);
	gr->DrawCachedBitmap(cb, 0, 0);
	delete cb;
}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics* gr = new Graphics(hdc);
	switch (this->typKresleni)
	{
	case kvalita:
		KreslitKvalita(gr, &rect);
		break;
	case cachedBitmap:
		KreslitCachedBitmap(gr);
		break;
	case normal:
		gr->DrawImage(bitmap, 0, 0, rect.right, rect.bottom);
		break;
	case podleOkna:
		UINT sirka = rect.right;
		UINT vyska = rect.bottom;
		int xPoz = 0;
		int yPoz = 0;
		if ((UINT)sirka < bitmap->GetWidth() ||
			(UINT)vyska < bitmap->GetHeight())
		{
			if ((float)sirka/(float)bitmap->GetWidth() >
				(float)vyska/(float)bitmap->GetHeight())
			{
				sirka = (bitmap->GetWidth()*vyska ) /
					bitmap->GetHeight();
				xPoz = (rect.right - sirka) / 2;
			}
			else
			{
				vyska = (bitmap->GetHeight()*sirka ) /
					bitmap->GetWidth();
				yPoz = (rect.bottom - vyska) / 2;
			}
		}
		else
		{
			sirka = this->bitmap->GetWidth();
			vyska = this->bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
			yPoz = (rect.bottom - vyska) / 2;
		}
		Rect rectCil(xPoz, yPoz, sirka, vyska);
		gr->DrawImage(bitmap,
			rectCil,
			0, 0,
			bitmap->GetWidth(),
			bitmap->GetHeight(),
			UnitPixel);
		break;
	}
	delete gr;
	EndPaint(&ps);

	return 0;
}

bool Vytvorit()
{
	RECT rect = {0, 0, 800, 600};
	if (!Create(NULL, rect, _aplikace.jmeno,
		WS_OVERLAPPEDWINDOW))
		return false;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return true;
}

LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	ZavritSoubor();
	this->bitmap = new Bitmap(this->soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		wcscpy_s(this->soubor, _countof(this->soubor), L"");
	}
	else
		RedrawWindow();
	return 0;
}

void ZavritSoubor()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

LRESULT OnZpusobZobrazeni(WORD, WORD id, HWND, BOOL&)
{
	switch (id)
	{
	case ID_CACHED_BITMAP:
		this->typKresleni = cachedBitmap;
		break;
	case ID_NORMAL:
		this->typKresleni = normal;
		break;
	case ID_PODLE_OKNA:
		this->typKresleni = podleOkna;
		break;
	case ID_KVALITA:
		this->typKresleni = kvalita;
		break;
	}
	RedrawWindow();
	return 0;
}

LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

void Zavrit()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

};

extern OknoHlavni _oknoHlavni;