/****************************************************
Soubor: DlgHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class DlgHlavni : public CDialogImpl< DlgHlavni >
{
public:
	enum { IDD = IDD_HLAVNI };
public:
	BEGIN_MSG_MAP(DlgHlavni)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnKonec)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnKonec)
	END_MSG_MAP()
public:

LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	HICON hicon = LoadIcon(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDI_HLAVNI));
	SetIcon(hicon, 1);
	SetIcon(hicon, 0);
	CAtlString text;
	text.LoadString(IDS_PROJNAME);
	SetWindowText(text);
	
	ImageCodecInfo* ici;
	UINT pocet;
	UINT velikost;
	
	GetImageDecodersSize(&pocet, &velikost);
	ici = (ImageCodecInfo*)malloc(velikost);
	GetImageDecoders(pocet, velikost, ici);
	PridatRadek(L"** Dekodry GDI+ **");
	PridatRadek(L"");
	wchar_t* strClsid;
	wchar_t szText[100];
	for (UINT i = 0; i < pocet; i++)
	{
		text.Format(L"Nzev: %s", ici[i].CodecName);
		PridatRadek(text);
		text.Format(L"Ppony soubor: %s",
			ici[i].FilenameExtension);
		PridatRadek(text);
		text.Format(L"Formt: %s", ici[i].FormatDescription);
		PridatRadek(text);
		text.Format(L"MIME typ: %s", ici[i].MimeType);
		PridatRadek(text);
		text.Format(L"Verze: %d", ici[i].Version);
		PridatRadek(text);
		StringFromCLSID(ici[i].Clsid, (LPOLESTR*)&strClsid);
		text.Format(L"CLSID: %s", strClsid);
		PridatRadek(text);
		StringFromGUID2(ici[i].FormatID,
			(LPOLESTR)szText, sizeof(szText)/sizeof(wchar_t));
		text.Format(L"Format ID: %s", szText);
		PridatRadek(text);
		if (ici[i].DllName)
		{
			text.Format(L"DLL knihovna: %s", ici[i].DllName);
			PridatRadek(text);
		}
		PridatRadek(L"");
	}
	free(ici);

	GetImageEncodersSize(&pocet, &velikost);
	ici = (ImageCodecInfo*)malloc(velikost);
	GetImageEncoders(pocet, velikost, ici);
	PridatRadek(L"");
	PridatRadek(L"** Kodeky GDI+ **");
	PridatRadek(L"");
	for (UINT i = 0; i < pocet; i++)
	{
		text.Format(L"Nzev: %s", ici[i].CodecName);
		PridatRadek(text);
		text.Format(L"Ppony soubor: %s",
			ici[i].FilenameExtension);
		PridatRadek(text);
		text.Format(L"Formt: %s", ici[i].FormatDescription);
		PridatRadek(text);
		text.Format(L"MIME typ: %s", ici[i].MimeType);
		PridatRadek(text);
		text.Format(L"Verze: %d", ici[i].Version);
		PridatRadek(text);
		StringFromCLSID(ici[i].Clsid, (LPOLESTR*)&strClsid);
		text.Format(L"CLSID: %s", strClsid);
		PridatRadek(text);
		StringFromGUID2(ici[i].FormatID,
			(LPOLESTR)szText, sizeof(szText)/sizeof(wchar_t));
		text.Format(L"Format ID: %s", szText);
		PridatRadek(text);
		if (ici[i].DllName)
		{
			text.Format(L"DLL knihovna: %s", ici[i].DllName);
			PridatRadek(text);
		}
		PridatRadek(L"");
	}
	free(ici);

	return 1;
}

LRESULT OnKonec(WORD, WORD id, HWND, BOOL&)
{
	EndDialog(id);
	return 0;
}

void PridatRadek(const wchar_t* text)
{
	SendDlgItemMessage(IDC_VYPIS, EM_SETSEL, 0, -1);
	SendDlgItemMessage(IDC_VYPIS, EM_SETSEL, -1);
	SendDlgItemMessage(IDC_VYPIS, EM_REPLACESEL,
		0, (LPARAM)text);
	SendDlgItemMessage(IDC_VYPIS, EM_REPLACESEL,
		0, (LPARAM)L"\r\n");
}

};
