/****************************************************
Soubor: Histogram.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/
 
#include "stdafx.h"
#include "resource.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public :
	DECLARE_LIBID(LIBID_ATLLib)

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)GetSysColorBrush(COLOR_WINDOW),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"HistogramUkazka",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	CString jmeno;
	ULONG_PTR gdiplusToken;
	Bitmap* bitmap;
	Bitmap* bitmapHistogram;
	Bitmap* bitmapHistogramR;
	Bitmap* bitmapHistogramG;
	Bitmap* bitmapHistogramB;
	wchar_t soubor[MAX_PATH];
	static const int vyskaHistogramu = 100;

	Aplikace()
	{
		this->bitmap = NULL;
		this->bitmapHistogram = NULL;
		this->bitmapHistogramR = NULL;
		this->bitmapHistogramG = NULL;
		this->bitmapHistogramB = NULL;
		this->soubor[0] = L'\0';
	}

	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_GETMINMAXINFO, OnGetMinMaxInfo)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_HISTOGRAM, OnHistogram)
		COMMAND_ID_HANDLER(ID_HISTOGRAM_VAZENY, OnHistogramVazeny)
		COMMAND_ID_HANDLER(ID_STUPNE_SEDE, OnPrevodSeda)
		COMMAND_ID_HANDLER(ID_STUPNE_SEDE_VAZENY, OnPrevodSedaVazeny)
		COMMAND_ID_HANDLER(ID_ZAVRIT, OnZavrit)
	END_MSG_MAP()

HRESULT PreMessageLoop(int nShowCmd)
{
	__super::PreMessageLoop(nShowCmd);

	Lock();
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	
	RECT rect = { 0, 0, 540, 600 };
	if (!Create(NULL, rect, jmeno,
		WS_OVERLAPPEDWINDOW, 0))
		return E_FAIL;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return S_OK;
}

HRESULT PostMessageLoop()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	if (this->bitmapHistogram)
	{
		delete this->bitmapHistogram;
		this->bitmapHistogram = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return __super::PostMessageLoop();
}

LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}


LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	ZavritSoubor();
	this->bitmap = new Bitmap(soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		this->soubor[0] = L'\0';
		return 0;
	}
	VytvoritHistogram(false);
	RedrawWindow();
	return 0;
}

void ZavritSoubor()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

LRESULT OnZavrit(WORD, WORD, HWND, BOOL&)
{
	ZavritSoubor();
	RedrawWindow();
	return 0;
}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL& bh)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	if (this->bitmapHistogram)
		rect.bottom -= 2*this->bitmapHistogram->GetHeight();
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics* graphics = new Graphics(hdc);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);

	Rect rectCilH(0,
		rect.bottom,
		this->bitmapHistogram->GetWidth(),
		this->bitmapHistogram->GetHeight());
	graphics->DrawImage(bitmapHistogram,
		rectCilH,
		0, 0,
		bitmapHistogram->GetWidth(),
		bitmapHistogram->GetHeight(),
		UnitPixel);

	Rect rectCilHR(256,
		rect.bottom,
		this->bitmapHistogramR->GetWidth(),
		this->bitmapHistogramR->GetHeight());
	graphics->DrawImage(bitmapHistogramR,
		rectCilHR,
		0, 0,
		bitmapHistogramR->GetWidth(),
		bitmapHistogramR->GetHeight(),
		UnitPixel);

	Rect rectCilHG(0,
		rect.bottom + vyskaHistogramu,
		this->bitmapHistogramR->GetWidth(),
		this->bitmapHistogramR->GetHeight());
	graphics->DrawImage(bitmapHistogramG,
		rectCilHG,
		0, 0,
		bitmapHistogramG->GetWidth(),
		bitmapHistogramG->GetHeight(),
		UnitPixel);

	Rect rectCilHB(256,
		rect.bottom + vyskaHistogramu,
		this->bitmapHistogramB->GetWidth(),
		this->bitmapHistogramB->GetHeight());
	graphics->DrawImage(bitmapHistogramB,
		rectCilHB,
		0, 0,
		bitmapHistogramG->GetWidth(),
		bitmapHistogramG->GetHeight(),
		UnitPixel);

	delete graphics;
	EndPaint(&ps);
	bh = TRUE;
	return 0;
}

void VytvoritHistogram(bool vazeny = true)
{
	if (!this->bitmap)
		return;
	if (!this->bitmapHistogram)
		this->bitmapHistogram = new Bitmap(
		256, vyskaHistogramu, PixelFormat24bppRGB);
	if (!this->bitmapHistogramR)
		this->bitmapHistogramR = new Bitmap(
		256, vyskaHistogramu, PixelFormat24bppRGB);
	if (!this->bitmapHistogramG)
		this->bitmapHistogramG = new Bitmap(
		256, vyskaHistogramu, PixelFormat24bppRGB);
	if (!this->bitmapHistogramB)
		this->bitmapHistogramB = new Bitmap(
		256, vyskaHistogramu, PixelFormat24bppRGB);
	Graphics* gr = Graphics::FromImage(this->bitmapHistogram);
	Graphics* grR = Graphics::FromImage(this->bitmapHistogramR);
	Graphics* grG = Graphics::FromImage(this->bitmapHistogramG);
	Graphics* grB = Graphics::FromImage(this->bitmapHistogramB);
	SolidBrush* brush = new SolidBrush(Color(64, 128, 128));
	gr->FillRectangle(brush, 0, 0,
		this->bitmapHistogram->GetWidth(),
		this->bitmapHistogram->GetHeight());
	grR->FillRectangle(brush, 0, 0,
		this->bitmapHistogramR->GetWidth(),
		this->bitmapHistogramR->GetHeight());
	grG->FillRectangle(brush, 0, 0,
		this->bitmapHistogramG->GetWidth(),
		this->bitmapHistogramG->GetHeight());
	grB->FillRectangle(brush, 0, 0,
		this->bitmapHistogramB->GetWidth(),
		this->bitmapHistogramB->GetHeight());
	int pocet[256];
	int pocetR[256];
	int pocetG[256];
	int pocetB[256];
	memset(&pocet, 0, sizeof(pocet));
	memset(&pocetR, 0, sizeof(pocetR));
	memset(&pocetG, 0, sizeof(pocetG));
	memset(&pocetB, 0, sizeof(pocetB));

	BitmapData bitmapData;
	if (bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bitmapData) != Ok)
		return;
	BYTE* pData = (BYTE*)bitmapData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bitmapData.Scan0 +
		(bitmapData.Height * bitmapData.Width * 3));
	while (pData < pKonec)
	{
		if (vazeny)
			pocet[((30 * (*pData)) +
				(59 * (*(pData+1))) + 
				(11 * (*(pData+2)))) / 100]++;
		else
			pocet[(*pData + *(pData+1) + *(pData+2)) / 3]++;
		pocetB[*pData]++;
		pocetG[*(pData+1)]++;
		pocetR[*(pData+2)]++;
		pData += 3;
	}
	bitmap->UnlockBits(&bitmapData);
	// najt maximum
	int max = 0;
	int maxR = 0;
	int maxG = 0;
	int maxB = 0;
	for (int i = 0; i < 256; i++)
	{
		if (pocet[i] > max)
			max = pocet[i];
		if (pocetR[i] > maxR)
			maxR = pocetR[i];
		if (pocetG[i] > maxG)
			maxG = pocetG[i];
		if (pocetB[i] > maxB)
			maxB = pocetB[i];
	}
	Pen* pen;
	for (int i = 0; i < 256; i++)
	{
		pen = new Pen(Color(i, i, i), 0);
		gr->DrawLine(pen,
			i, bitmapHistogram->GetHeight(),
			i, bitmapHistogram->GetHeight() -
			(pocet[i] * vyskaHistogramu / max));
		delete pen;

		pen = new Pen(Color(i, 0, 0), 0);
		grR->DrawLine(pen,
			i, bitmapHistogramR->GetHeight(),
			i, bitmapHistogramR->GetHeight() -
			(pocetR[i] * vyskaHistogramu / maxR));
		delete pen;

		pen = new Pen(Color(0, i, 0), 0);
		grG->DrawLine(pen,
			i, bitmapHistogramG->GetHeight(),
			i, bitmapHistogramG->GetHeight() -
			(pocetG[i] * vyskaHistogramu / maxG));
		delete pen;

		pen = new Pen(Color(0, 0, i), 0);
		grB->DrawLine(pen,
			i, bitmapHistogramB->GetHeight(),
			i, bitmapHistogramB->GetHeight() -
			(pocetB[i] * vyskaHistogramu / maxB));
		delete pen;
	}
	delete gr;
	delete grR;
	delete grG;
	delete grB;
	RedrawWindow();
}

LRESULT OnHistogram(WORD, WORD, HWND, BOOL&)
{
	VytvoritHistogram(false);
	return 0;
}

LRESULT OnHistogramVazeny(WORD, WORD, HWND, BOOL&)
{
	VytvoritHistogram(true);
	return 0;
}

LRESULT OnPrevodSeda(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 3));
	BYTE b;
	while (pData < pKonec)
	{
		b = (*(pData+2) + *(pData+1) + *pData) / 3;
		*(pData) = b;
		*(pData + 1) = b;
		*(pData + 2) = b;
		pData += 3;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT OnPrevodSedaVazeny(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 3));
	BYTE b;
	while (pData < pKonec)
	{
		b = ((11 * (*(pData+2)) + 59 *
			(*(pData+1))+ 30 * (*(pData)))) / 100;
		*(pData) = b;
		*(pData + 1) = b;
		*(pData + 2) = b;
		pData += 3;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT OnGetMinMaxInfo(UINT uMsg,
	WPARAM wParam, LPARAM lParam, BOOL&)
{
	((MINMAXINFO*)lParam)->ptMinTrackSize.x =
		512 + 2*GetSystemMetrics(SM_CXSIZEFRAME);
	((MINMAXINFO*)lParam)->ptMinTrackSize.y = 350;
	return DefWindowProc();
}

};

Aplikace _aplikace;

extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}
