/****************************************************
Soubor: OknoHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoHlavni : public CWindowImpl< OknoHlavni >
{
public:
	enum TypKresleni
	{
		kreslitCary,
		kreslitPlochy,
		kreslitText
	};

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"GrafikaGdiPlus",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL,
			NULL,
			IDC_ARROW,
			TRUE,
			0,
			L""
		};
		return wc;
	}

public:
	TypKresleni typKresleni;

public:
	OknoHlavni(void)
	{
		typKresleni = kreslitText;
	}


	BEGIN_MSG_MAP(OknoHlavni)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_KRESLIT_CARY, OnKreslitCary)
		COMMAND_ID_HANDLER(ID_KRESLIT_TEXT, OnKreslitText)
		COMMAND_ID_HANDLER(ID_KRESLIT_PLOCHY, OnKreslitPlochy)
	END_MSG_MAP()


bool Vytvorit()
{
	RECT rect = {0, 0, 500, 600 };
	if (!Create(NULL, rect, _aplikace.jmeno,
		WS_OVERLAPPEDWINDOW, 0))
		return false;;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return true;
}


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}


void KreslitPlochy(HDC hdc)
{
	RECT rect;
	GetClientRect(&rect);
	Graphics gr(hdc);

	LinearGradientBrush lgBrush(
		Point(0, 0),
		Point(rect.right, rect.bottom),
		Color(0xFF,  0xFF, 0xFF, 0x00),
		Color(0xFF, 0, 0, 0xFF));
	gr.FillRectangle(&lgBrush, 0, 0,
		rect.right, rect.bottom);

	SolidBrush solidBrush(Color(0xFF, 0xD0, 0, 0));
	gr.FillEllipse(&solidBrush, 10, 10, rect.right / 2 - 20, 100);
	Bitmap bitmapVypln(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCEW(IDB_VYPLN));
	TextureBrush tbVypln(&bitmapVypln);
	gr.FillEllipse(&tbVypln, rect.right / 2 + 10,
		10, rect.right / 2 - 20, 100);

	HatchBrush hatchBrush(HatchStyleDottedDiamond,
		Color(0xFF, 0xFF, 0, 0),
		Color(0xFF, 0x80, 0xFF, 0xFF));
	gr.FillEllipse(&hatchBrush, rect.right / 2 - 50,
		120, 100, 100);

}

void KreslitCary(HDC hdc)
{
	RECT rect;
	GetClientRect(&rect);
	Graphics gr(hdc);
	Pen penCerny(Color(0xFF, 0, 0, 0), 1);
	Pen penZluty(Color(0xFF, 0xFF, 0xFF, 0x40), 12);

	gr.DrawLine(&penZluty,
		20, 20, rect.right - 20, 20);
	gr.DrawLine(&penCerny,
		20, 20, rect.right - 20, 20);

	gr.DrawRectangle(&penZluty,
		20, 40, rect.right - 40, 50);
	gr.DrawRectangle(&penCerny,
		20, 40, rect.right - 40, 50);

	penZluty.SetAlignment(PenAlignmentInset);
	gr.DrawRectangle(&penZluty,
		20, 110, rect.right - 40, 50);
	gr.DrawRectangle(&penCerny,
		20, 110, rect.right - 40, 50);

	Pen penCerveny(Color(0xFF, 0xFF, 0x40, 0x40), 20);
	penCerveny.SetEndCap(LineCapArrowAnchor);
	penCerveny.SetStartCap(LineCapRoundAnchor);
	gr.DrawLine(&penCerveny,
		40, 190, rect.right / 2 -20, 190);
	penCerveny.SetEndCap(LineCapTriangle);
	penCerveny.SetStartCap(LineCapDiamondAnchor);
	gr.DrawLine(&penCerveny, rect.right / 2 + 20 ,
		190, rect.right - 20, 190);

	Bitmap bitmapVypln(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCEW(IDB_VYPLN));
	TextureBrush tbVypln(&bitmapVypln);
	Pen penVypln(&tbVypln, 40);
	gr.DrawEllipse(&penVypln,
		40, 240, rect.right - 100, 100);
	GraphicsPath path;
	path.StartFigure();
	path.AddLine(Point(50, 390), Point(90, 390));
	path.AddLine(Point(90, 480), Point(90, 480));
	penCerveny.SetStartCap(LineCapTriangle);
	penCerveny.SetEndCap(LineCapTriangle);
	penCerveny.SetLineJoin(LineJoinMiter);
	gr.DrawPath(&penCerveny, &path);

	path.StartFigure();
	path.AddLine(Point(120, 390), Point(160, 390));
	path.AddLine(Point(160, 480), Point(160, 480));
	penCerveny.SetLineJoin(LineJoinRound);
	gr.DrawPath(&penCerveny, &path);

	path.StartFigure();
	path.AddLine(Point(200, 390), Point(240, 390));
	path.AddLine(Point(240, 480), Point(240, 480));
	penCerveny.SetLineJoin(LineJoinBevel);
	gr.DrawPath(&penCerveny, &path);
}

void KreslitText(HDC hdc)
{
	RECT rect;
	GetClientRect(&rect);
	Graphics gr(hdc);

	FontFamily fontFamily(L"Comic Sans MS");
	Font font(&fontFamily,
		26, FontStyleRegular, UnitPixel);
	PointF pointF(10, 10);
	SolidBrush solidBrush(Color(0xFF, 0, 0, 0xFF));
	gr.DrawString(L"Psmo Comic Sans MS",
		-1, &font, pointF, &solidBrush);

	Bitmap bitmapVypln(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCEW(IDB_VYPLN));
	TextureBrush tbVypln(&bitmapVypln);
	PointF pointF2(2, 40);
	Font fontTucny(&fontFamily,
		64, FontStyleBoldItalic, UnitPixel);
	gr.DrawString(L"Psmo vpl", -1,
		&fontTucny, pointF2, &tbVypln);

	SolidBrush solidBrush2(Color(0xFF, 0, 0xA0, 0));
	wchar_t text[] = 
	   L"Vpis textu do danho obdlnka. "
	   L"Vpis textu do danho obdlnka. "
	   L"Vpis textu do danho obdlnka.";
	                       
	FontFamily ffVerdana(L"Verdana");
	Font fontVerdana(&ffVerdana,
		11, FontStyleBold, UnitPoint);
	RectF rectText(10, 140, 160, 160);
	gr.DrawString(text, -1, &fontVerdana,
		rectText, NULL, &solidBrush2);
	Pen pen(Color(255, 0, 0, 0));
	gr.DrawRectangle(&pen, rectText);

	wchar_t textC[] = 
	   L"Text centrovan do danho obdlnka. "
//	   L"Text centrovan do danho obdlnka. "
	   L"Text centrovan do danho obdlnka. ";
	RectF rectText2(200, 140, 160, 160);
	StringFormat stringFormat;
	stringFormat.SetAlignment(StringAlignmentCenter);
	stringFormat.SetLineAlignment(StringAlignmentCenter);
	gr.DrawString(textC, -1, &fontVerdana,
		rectText2, &stringFormat, &solidBrush2);
	gr.DrawRectangle(&pen, rectText2);

	PointF pointV(rect.right - 40, 20);
	StringFormat stringFormatV(StringFormatFlagsDirectionVertical);
	SolidBrush  solidBrush3(Color(0xFF, 0xFF, 0, 0));
	gr.DrawString(L"Svisl text v okn vpravo", -1, &font,
		pointV, &stringFormatV, &solidBrush3);


}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	switch (this->typKresleni)
	{
	case kreslitCary:
		KreslitCary(hdc);
		break;
	case kreslitPlochy:
		KreslitPlochy(hdc);
		break;
	case kreslitText:
		KreslitText(hdc);
		break;
	}
	EndPaint(&ps);
	return 0;
}


LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}


LRESULT OnKreslitCary(WORD, WORD, HWND, BOOL&)
{
	this->typKresleni = kreslitCary;
	RedrawWindow();
	return 0;
}

LRESULT OnKreslitPlochy(WORD, WORD, HWND, BOOL&)
{
	this->typKresleni = kreslitPlochy;
	RedrawWindow();
	return 0;
}


LRESULT OnKreslitText(WORD, WORD, HWND, BOOL&)
{
	this->typKresleni = kreslitText;
	RedrawWindow();
	return 0;
}

};

extern OknoHlavni _oknoHlavni;