/****************************************************
Soubor: Registry.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class Registry
{
private:
	CString strKlic;
	HKEY hKey;

public:
Registry(const wchar_t* klic)
{
	this->hKey = NULL;
	if (klic)
		this->strKlic = CString(klic);
}

bool KlicExistuje(const wchar_t* pszJmenoKlice = NULL)
{
	Zavrit();
	CString klic;
	klic = CString(this->strKlic.GetBuffer());
	if (pszJmenoKlice)
	{
		klic += L"\\";
		klic += pszJmenoKlice;
	}
	HKEY hkVysledek = NULL;
	if (RegOpenKeyEx(HKEY_CURRENT_USER, klic.GetBuffer(),
		0, KEY_QUERY_VALUE, &hkVysledek) == ERROR_SUCCESS)
	{
		if (RegCloseKey(hkVysledek) != ERROR_SUCCESS)
			AtlThrowLastWin32();
		else
			return true;
	}
	else
		return false;
}

void Zavrit(bool flush = false)
{
	if (this->hKey)
	{
		if (flush)
			RegFlushKey(this->hKey);
		if (RegCloseKey(this->hKey) != ERROR_SUCCESS)
			AtlThrowLastWin32();
		else
			this->hKey = NULL;
	}
}

void ZapsatCislo(const wchar_t* pszJmenoHodnoty, DWORD dwHodnota)
{
	if (!this->hKey)
		AtlThrow(E_INVALIDARG);
	else
		if (RegSetValueEx(this->hKey, pszJmenoHodnoty, 0, REG_DWORD,
			(CONST BYTE*)&dwHodnota, sizeof(DWORD)) != ERROR_SUCCESS)
			AtlThrowLastWin32();
}

void ZapsatText(const wchar_t* pszJmenoHodnoty, const wchar_t* pszText)
{
	if (!this->hKey)
		AtlThrow(E_INVALIDARG);
	if (RegSetValueEx(this->hKey, pszJmenoHodnoty, 0, REG_SZ,
		(CONST BYTE*)pszText, (DWORD)(wcslen(pszText)+1)*sizeof(wchar_t)) != ERROR_SUCCESS)
		throw 0;
}

bool NacistCislo(const wchar_t* pszJmenoHodnoty, DWORD& rdwHodnota)
{
	if (this->hKey == NULL)
		AtlThrow(E_INVALIDARG);
	if (!HodnotaExistuje(pszJmenoHodnoty))
		return false;
	DWORD dwValue, dwSize, dwType;
	dwSize = sizeof(DWORD);
	dwValue = 0;
	if (RegQueryValueEx(this->hKey, pszJmenoHodnoty, NULL, &dwType, (LPBYTE)&dwValue, &dwSize)
			!= ERROR_SUCCESS)
		return false;
	else
	{
		rdwHodnota = dwValue;
		return true;
	}
}


bool NacistText(const wchar_t* pszJmenoHodnoty, CString& rString)
{
	if (this->hKey == NULL)
		AtlThrow(E_INVALIDARG);
	if (!HodnotaExistuje(pszJmenoHodnoty))
		return false;
	DWORD dwType, dwCount;
	LONG lResult = RegQueryValueEx(this->hKey, pszJmenoHodnoty, NULL, &dwType,
		NULL, &dwCount);
	if (lResult == ERROR_SUCCESS)
	{
		if (dwType != REG_SZ)
			AtlThrow(E_INVALIDARG);
		lResult = RegQueryValueEx(this->hKey, pszJmenoHodnoty, NULL, &dwType,
			(BYTE*)rString.GetBufferSetLength(dwCount/sizeof(TCHAR)), &dwCount);
		rString.ReleaseBuffer();
	}
	if (lResult == ERROR_SUCCESS)
		return (dwType == REG_SZ) ? true : false;
	else
		return false;
}


bool HodnotaExistuje(const wchar_t* pszHodnota)
{
	if (!this->hKey)
	{
		AtlThrow(E_INVALIDARG);
		return false;
	}
	else
		return (RegQueryValueEx(this->hKey, pszHodnota, NULL, NULL, NULL, NULL) == ERROR_SUCCESS);
}


void Otevrit(const wchar_t* pszKlic = NULL)
{
	Zavrit();
	if (this->strKlic.GetLength() == 0)
		AtlThrow(E_INVALIDARG);
	CString klic;
	klic = CString(this->strKlic.GetBuffer());
	if (pszKlic)
	{
		klic += L"\\";
		klic += pszKlic;
	}
	HKEY hkVysledek = NULL;
	DWORD dwDisp = 0;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, klic.GetBuffer(), 0, NULL, REG_OPTION_NON_VOLATILE,
			KEY_SET_VALUE | KEY_CREATE_SUB_KEY | KEY_ENUMERATE_SUB_KEYS |
			KEY_EXECUTE | KEY_QUERY_VALUE,
			NULL, &hkVysledek, &dwDisp) != ERROR_SUCCESS )
			AtlThrowLastWin32();
	this->hKey = hkVysledek;
	if (hkVysledek == NULL)
		AtlThrowLastWin32();
}

};

