/****************************************************
Soubor: OknoNahled.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoNahled : public CWindowImpl< OknoNahled >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)NULL,
				(HCURSOR)NULL,
				(HBRUSH)GetSysColorBrush(COLOR_3DFACE),
				NULL, // menu
				_aplikace.tridaNahled,
				(HICON)NULL
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	Bitmap* bitmap;

public:
	OknoNahled()
	{
		bitmap = NULL;
	}

public:
	BEGIN_MSG_MAP(OknoNahled)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
	END_MSG_MAP()


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	PostQuitMessage(0);
	return DefWindowProc();
}


LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(&ps);
	RECT rect;
	GetClientRect(&rect);

	Graphics* graphics = new Graphics(hDC);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);
	delete graphics;


	SetTextColor(hDC, 0x0020FFFF);
	SetBkMode(hDC, TRANSPARENT);
	rect.top += 6;
	DrawText(hDC,  L"Foto Spoi", -1,
		&rect, DT_TOP | DT_CENTER | DT_SINGLELINE);
	EndPaint(&ps);
	return 0;
}


void Vytvorit()
{
	RECT rect;
	::GetClientRect(_aplikace.hwndParent, &rect);
	if (!Create(_aplikace.hwndParent, rect,
		_aplikace.tridaNahled,
		WS_CHILD ,
		WS_EX_TOPMOST))
		AtlThrowLastWin32();
	bitmap = new Bitmap(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDB_NAHLED));
	ShowWindow(SW_SHOW);
}

};

extern OknoNahled _oknoNahled;