/****************************************************
Soubor: OknoHlavni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class OknoHlavni : public CWindowImpl< OknoHlavni >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)NULL,
				(HCURSOR)NULL,
				(HBRUSH)NULL,
				NULL, // menu
				_aplikace.tridaSporic,
				(HICON)NULL
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}
public:
	static const int citlivostMysi = 3;

public:
	Bitmap* bitmap;
	HBRUSH hbrushPozadi;
	CAtlArray<CString> soubory;
	int indexSouboru;
	POINT ptStart;
	POINTS ptsCursor;

public:
	OknoHlavni()
	{
		this->bitmap = NULL;
		this->indexSouboru = -1;
	}

	~OknoHlavni()
	{
		if (hbrushPozadi)
			DeleteObject(hbrushPozadi);
	}

	BEGIN_MSG_MAP(OknoHlavni)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_CREATE, OnCreate)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_KEYUP, OnKeyUp)
		MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
		MESSAGE_HANDLER(WM_LBUTTONUP, OnMouseUp)
		MESSAGE_HANDLER(WM_MBUTTONUP, OnMouseUp)
		MESSAGE_HANDLER(WM_RBUTTONUP, OnMouseUp)
		MESSAGE_HANDLER(WM_MOUSEWHEEL, OnMouseUp)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		MESSAGE_HANDLER(WM_TIMER, OnTimer)
	END_MSG_MAP()


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}


LRESULT OnCreate(UINT, WPARAM, LPARAM, BOOL&)
{
	GetCursorPos(&ptStart);
	return DefWindowProc();
}


LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	KillTimer(1);
	return DefWindowProc();
}


LRESULT OnMouseUp(UINT, WPARAM, LPARAM lParam, BOOL&)
{
	PostMessage(WM_CLOSE);
	return DefWindowProc();
}

LRESULT OnMouseMove(UINT, WPARAM, LPARAM lParam, BOOL&)
{
	ptsCursor = MAKEPOINTS(lParam);
	if (abs(ptsCursor.x - ptStart.x) <=  citlivostMysi)
		return DefWindowProc();
	if (abs(ptsCursor.y - ptStart.y) <= citlivostMysi )
		return DefWindowProc();
	PostMessage(WM_CLOSE);
	return DefWindowProc();
}


LRESULT OnKeyUp(UINT, WPARAM, LPARAM, BOOL&)
{
	PostMessage(WM_CLOSE);
	return DefWindowProc();
}


void Vytvorit()
{
	hbrushPozadi = CreateSolidBrush(_aplikace.nastaveni.barvaPozadi);
	RECT rect = {0, 0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN)};
	if (!Create(NULL, rect, NULL,
		WS_POPUP, 0/*WS_EX_TOPMOST*/))
		AtlThrowLastWin32();
	NacistSoubory();
	PostMessage(WM_TIMER, 1);
	SetTimer(1, _aplikace.nastaveni.interval*1000);
	ShowWindow(SW_SHOW);
}


int NacistSoubory()
{
	if (!PathFileExists(_aplikace.nastaveni.slozka))
	{
		PostMessage(WM_CLOSE);
		return -1;
	}
	wchar_t maska[MAX_PATH];
	wcscpy_s(maska,	_countof(maska),
		_aplikace.nastaveni.slozka.GetBuffer());
	wcscat_s(maska,
		_countof(maska), L"\\*.jpg");
	WIN32_FIND_DATA wfd;
	HANDLE hFind = FindFirstFile(maska, &wfd);
	if (hFind == INVALID_HANDLE_VALUE)
		return 0;
	CString soubor;
	do
	{
		soubor = CString(_aplikace.nastaveni.slozka);
		soubor.Append(L"\\");
		soubor.Append(wfd.cFileName);
		this->soubory.Add(soubor);
	}
	while (FindNextFileW(hFind, &wfd));
	FindClose(hFind);
	return (int)this->soubory.GetCount();
}


LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);

	HDC hdcPamet = CreateCompatibleDC(0);
	HBITMAP hBitmapPamet =
		CreateCompatibleBitmap(hdc,
		rect.right, rect.bottom);
	SelectObject(hdcPamet, hBitmapPamet);
	FillRect(hdcPamet, &rect, hbrushPozadi);

	Graphics* graphics = new Graphics(hdcPamet);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);
	delete graphics;
	BitBlt(hdc,
		0,	0,
		rect.right, rect.bottom,
		hdcPamet,
		0, 0, SRCCOPY);
	EndPaint(&ps);
	DeleteDC(hdcPamet);
	DeleteObject(hBitmapPamet);
	return 0;
}


LRESULT OnTimer(UINT, WPARAM, LPARAM, BOOL&)
{
	this->indexSouboru++;
	if (this->indexSouboru >= (int)this->soubory.GetCount())
		this->indexSouboru = 0;
	CString soubor = (CString)
		this->soubory.GetAt(this->indexSouboru);
	if (this->bitmap)
		delete this->bitmap;
	this->bitmap = new Bitmap(soubor);
	RedrawWindow();
	return 0;
}

};

extern OknoHlavni _oknoHlavni;