/****************************************************
Soubor: DlgNastaveni.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

class DlgNastaveni : public CDialogImpl< DlgNastaveni >
{
public:
	enum { IDD = IDD_NASTAVENI };

	static int CALLBACK BrowseCallbackProc(HWND hWnd,
		UINT uMsg, LPARAM lParam, LPARAM lpData)
	{
		wchar_t szDir[MAX_PATH];
		switch (uMsg)
		{
		case BFFM_INITIALIZED:
			if (lpData)
				::SendMessage(hWnd,
				BFFM_SETSELECTION,
				TRUE, (LPARAM)lpData);
			break;
		case BFFM_SELCHANGED:
			if (SHGetPathFromIDList(
				(LPITEMIDLIST)lParam, szDir))
				::SendMessage(hWnd,
				BFFM_SETSTATUSTEXT, 0, (LPARAM)szDir);
			break;
		}
		return 0;
	}

public:
	BEGIN_MSG_MAP(DlgNastaveni)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		COMMAND_HANDLER(IDOK, BN_CLICKED, OnOK)
		COMMAND_HANDLER(IDCANCEL, BN_CLICKED, OnStorno)
		COMMAND_HANDLER(IDC_BARVA_POZADI,
			BN_CLICKED, OnBarvaPozadi)
		COMMAND_HANDLER(IDC_VYBRAT_SLOZKU,
			BN_CLICKED, OnVybratSlozku)
	END_MSG_MAP()


LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL&)
{
	SetIcon(_aplikace.hicon, TRUE);
	SetIcon(_aplikace.hiconMala, FALSE);
	CString text;
	text.LoadString(IDS_PROJNAME);
	text.Append(L" - Nastaven");
	SetWindowText(text);
	SetDlgItemText(IDC_SLOZKA, _aplikace.nastaveni.slozka);
	SetDlgItemInt(IDC_INTERVAL, _aplikace.nastaveni.interval);
	return 1;
}

LRESULT OnOK(WORD, WORD wID, HWND, BOOL&)
{
	GetDlgItemText(IDC_SLOZKA, _aplikace.nastaveni.slozka);
	BOOL bOK;
	UINT cislo = GetDlgItemInt(IDC_INTERVAL, &bOK, FALSE);
	if (bOK && cislo > 0 && cislo < 1000)
		_aplikace.nastaveni.interval = cislo;
	_aplikace.ZapsatNastaveni();
	EndDialog(wID);
	return 0;
}

LRESULT OnStorno(WORD, WORD wID, HWND, BOOL&)
{
	EndDialog(wID);
	return 0;
}

LRESULT OnBarvaPozadi(WORD, WORD wID, HWND, BOOL&)
{
		CHOOSECOLOR cc;
		static COLORREF crVychozi[16] = 
		{
			0x00000000,
			0x00FFFFFF,
			0x00FF0000,
			0x0000FF00,
			0x000000FF,
			0x00FF00FF,
			0x00FFFF00,
			0x0000FFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
			0x00FFFFFF,
		};
		memset(&cc, 0, sizeof(cc));
		cc.lStructSize = sizeof(cc);
		cc.lpCustColors = crVychozi;
		cc.hwndOwner = m_hWnd;
		cc.rgbResult = _aplikace.nastaveni.barvaPozadi;
		cc.Flags = CC_FULLOPEN | CC_RGBINIT;
		if (!ChooseColor(&cc))
			return 0;
		_aplikace.nastaveni.barvaPozadi = cc.rgbResult;
	return 0;
}

LRESULT OnVybratSlozku(WORD, WORD wID, HWND, BOOL&)
{
	wchar_t slozka[MAX_PATH];
	GetDlgItemText(IDC_SLOZKA, slozka, MAX_PATH);
	if (wcslen(slozka) == 0)
	{
		GetCurrentDirectory(sizeof(slozka)/sizeof(wchar_t),
			slozka);
	}
	LPITEMIDLIST pidl = NULL;
	BROWSEINFO bi;
	memset(&bi, 0, sizeof(bi));
	LPMALLOC pMalloc = NULL;
	SHGetMalloc(&pMalloc);
	bi.hwndOwner = m_hWnd;
	bi.pszDisplayName = 0;
	bi.pidlRoot = 0;
	bi.lParam = (LPARAM)slozka;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;
	bi.lpfn = BrowseCallbackProc;
	bi.lpszTitle = L"Vyberte poadovanou sloku";
	pidl = SHBrowseForFolder(&bi);
	if (pidl)
	{
		SHGetPathFromIDList(pidl, slozka);
		pMalloc->Free(pidl);
	}
	pMalloc->Release();
	SetDlgItemText(IDC_SLOZKA, slozka);
	return 0;
}

};
