/****************************************************
Soubor: Aplikace.h
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#pragma once

#include "resource.h"
#include "Registry.h"

struct Nastaveni
{
	CString slozka;
	DWORD interval;
	DWORD barvaPozadi;
};

class Aplikace : public CAtlExeModuleT< Aplikace >
{
public:
	DECLARE_LIBID(LIBID_ATLLib)

	const wchar_t* registryKlic;
	const wchar_t* tridaNahled;
	const wchar_t* tridaSporic;

	HICON hicon;
	HICON hiconMala;
	CString cmdLine;
	Nastaveni nastaveni;
	ULONG_PTR gdiplusToken;
	HWND hwndParent;


	Aplikace()
	{
		this->gdiplusToken = 0;
		this->hicon = NULL;
		this->hiconMala = NULL;
		this->hwndParent = NULL;
		registryKlic = L"Software\\Radek Chalupa\\Demo\\FotoSporic";
		tridaSporic = L"FotoSporicHlavni";
		tridaNahled = L"FotoSporicNahled";
	}

	~Aplikace()
	{
		if (this->hicon)
		{
			DestroyIcon(this->hicon);
			this->hicon = NULL;
		}
		if (this->hiconMala)
		{
			DestroyIcon(this->hiconMala);
			this->hiconMala = NULL;
		}
	}

public:
	HRESULT PreMessageLoop(int nShowCmd);

	HRESULT SpustitSporic();
	HRESULT SpustitNahled();
	HRESULT SpustitNastaveni();

	void VychoziNastaveni()
	{
		nastaveni.barvaPozadi = GetSysColor(COLOR_DESKTOP);
		nastaveni.interval = 5;
		SHGetFolderPath(NULL, CSIDL_MYPICTURES, NULL, SHGFP_TYPE_CURRENT,
			nastaveni.slozka.GetBufferSetLength(MAX_PATH));
		nastaveni.slozka.ReleaseBuffer();
	}

	void NacistNastaveni()
	{
		Registry reg(registryKlic);
		reg.Otevrit();
		reg.NacistCislo(L"barvaPozadi", nastaveni.barvaPozadi);
		reg.NacistCislo(L"interval", nastaveni.interval);
		reg.NacistText(L"slozka", nastaveni.slozka);
		reg.Zavrit();
	}

	void ZapsatNastaveni()
	{
		Registry reg(registryKlic);
		reg.Otevrit();
		reg.ZapsatCislo(L"barvaPozadi", nastaveni.barvaPozadi);
		reg.ZapsatCislo(L"interval", nastaveni.interval);
		reg.ZapsatText(L"slozka", nastaveni.slozka);
		reg.Zavrit();
	}
public:
	HRESULT PostMessageLoop();
};

extern Aplikace _aplikace;
