/****************************************************
Soubor: Aplikace.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "Aplikace.h"
#include "DlgNastaveni.h"
#include "OknoHlavni.h"
#include "OknoNahled.h"


Aplikace _aplikace;


//
extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR cmdLine, int nShowCmd)
{
	_aplikace.cmdLine = CString(cmdLine);
    return _aplikace.WinMain(nShowCmd);
}


HRESULT Aplikace::PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);

	 // hledme okno naeho spoie
	if (FindWindow(tridaSporic, NULL))
		return S_FALSE; // ukonme aplikaci hned
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;
	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;

	this->hicon = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR);
	if (!this->hicon)
		return E_HANDLE;
	this->hiconMala = (HICON)LoadImage(
		_AtlBaseModule.m_hInst, MAKEINTRESOURCE(IDI_HLAVNI),
		IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	if (!this->hiconMala)
		return E_HANDLE;

	int pozice = 0;
	CString strToken = cmdLine.Tokenize(L" :", pozice);
	if (strToken != L"")
	{
		strToken.TrimLeft(L"/");
		strToken.TrimLeft(L"-");
		strToken.MakeLower();
		if (strToken == "p")
		{
			strToken = cmdLine.Tokenize(L" :", pozice);
#pragma warning(push)
#pragma warning(disable: 4312)
			this->hwndParent = (HWND)_wtol(strToken.GetBuffer());
#pragma warning(pop)
			if (::IsWindow(this->hwndParent))
				return SpustitNahled();
			else
				return SpustitSporic();
		}
		if (strToken == "c")
		{
			return SpustitNastaveni();
		}
		if (strToken == "s")
		{
			return SpustitSporic();
		}
	}

	return SpustitNastaveni();
}

HRESULT Aplikace::SpustitSporic()
{
	try
	{
		VychoziNastaveni();
		NacistNastaveni();
		ShowCursor(FALSE);
		_oknoHlavni.Vytvorit();
		return S_OK;
	}
	catch (...)
	{
		ShowCursor(TRUE);
		return S_FALSE;
	}
}

HRESULT Aplikace::SpustitNastaveni()
{
	VychoziNastaveni();
	NacistNastaveni();
	DlgNastaveni().DoModal();
	if (this->hicon)
	{
		DestroyIcon(this->hicon);
		this->hicon = NULL;
	}
	if (this->hiconMala)
	{
		DestroyIcon(this->hiconMala);
		this->hiconMala = NULL;
	}
	return S_FALSE;
}

HRESULT Aplikace::SpustitNahled()
{
	try
	{
		VychoziNastaveni();
		NacistNastaveni();
		_oknoNahled.Vytvorit();
		return S_OK;
	}
	catch (...)
	{
		return S_FALSE;
	}
}

HRESULT Aplikace::PostMessageLoop()
{
	ShowCursor(TRUE);
	if (gdiplusToken != 0)
	{
		GdiplusShutdown(gdiplusToken);
		gdiplusToken = 0;
	}
	if (this->hicon)
	{
		DestroyIcon(this->hicon);
		this->hicon = NULL;
	}
	if (this->hiconMala)
	{
		DestroyIcon(this->hiconMala);
		this->hiconMala = NULL;
	}
	Unlock();
	return CAtlExeModuleT<Aplikace>::PostMessageLoop();
}
