/****************************************************
Soubor: ExifInfo.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/
 
#include "stdafx.h"
#include "resource.h"
#include "ExifInfo.h"

struct sRational
{
	LONG long1;
	LONG long2;
};

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl < Aplikace >
{
public :
	DECLARE_LIBID(LIBID_ATLLib)


	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)GetSysColorBrush(COLOR_APPWORKSPACE),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"ExifInformace",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	static const int vyskaListView = 280;


	CString jmeno;
	ULONG_PTR gdiplusToken;
	Bitmap* bitmap;
	wchar_t soubor[MAX_PATH];
	CWindow listView;

	Aplikace()
	{
		this->bitmap = NULL;
		this->soubor[0] = L'\0';
	}

BEGIN_MSG_MAP(Aplikace)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	MESSAGE_HANDLER(WM_PAINT, OnPaint)
	MESSAGE_HANDLER(WM_SIZE, OnSize)
	COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
	COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
	COMMAND_ID_HANDLER(ID_ZAVRIT, OnZavrit)
END_MSG_MAP()


HRESULT PreMessageLoop(int nShowCmd)
{
	__super::PreMessageLoop(nShowCmd);

	Lock();
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	
	RECT rect = { 0, 0, 500, 600 };
	if (!Create(NULL, rect, jmeno,
		WS_OVERLAPPEDWINDOW |
		WS_CLIPCHILDREN | WS_CLIPSIBLINGS, 0))
		return E_FAIL;

	if (!listView.Create(WC_LISTVIEWW,
			m_hWnd, &rect, NULL,
			WS_CHILD | WS_VISIBLE |
			LVS_REPORT | LVS_SHOWSELALWAYS,
			LVS_EX_FULLROWSELECT, 1))
		return E_FAIL;

	LVCOLUMN lvc;
	memset(&lvc, 0, sizeof(lvc));
	lvc.mask = LVCF_WIDTH | LVCF_TEXT;
	lvc.pszText = (wchar_t*)L"Poloka";
	lvc.cx = 170;
	if (ListView_InsertColumn(listView, 0, &lvc) == -1)
		return E_FAIL;
	lvc.pszText = (wchar_t*)L"Obsah";
	lvc.cx = 300;
	if (ListView_InsertColumn(listView, 1, &lvc) == -1)
		return E_FAIL;
	CenterWindow();
	listView.ShowWindow(SW_SHOW);
	ShowWindow(SW_SHOW);

	return S_OK;
}

int PridatPolozkuSeznamu(const wchar_t* text, int index)
{
	LVITEM lvi;
	int polozka;
	memset(&lvi, 0, sizeof(lvi));
	lvi.mask = LVIF_TEXT | LVIF_PARAM;
	lvi.pszText = (wchar_t*)text;
	lvi.iItem = index;
	polozka = ListView_InsertItem(listView.m_hWnd, &lvi);
	if (polozka == -1)
		throw 0;
	else
		return polozka;
}


bool SetTextPolozky(int polozka, const wchar_t* text)
{
	ListView_SetItemText(listView.m_hWnd,
		polozka, 1, (wchar_t*)text);
	return true;
}


HRESULT PostMessageLoop()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return __super::PostMessageLoop();
}


LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}


LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}


LRESULT OnSize(UINT, WPARAM, LPARAM lParam, BOOL&)
{
	if (listView.IsWindow())
	{
		listView.SetWindowPos(NULL,
			0, HIWORD(lParam) - vyskaListView,
			LOWORD(lParam), vyskaListView,
			SWP_NOZORDER);
	}

	return DefWindowProc();
}


LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	rect.bottom -= (vyskaListView + 2);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics* graphics = new Graphics(hdc);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);

	delete graphics;
	EndPaint(&ps);
	return 0;
}


LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	ZavritSoubor();
	this->bitmap = new Bitmap(soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		this->soubor[0] = L'\0';
		return 0;
	}
	VypsatExif();
	RedrawWindow();
	return 0;
}

bool VypsatExif()
{
	ListView_DeleteAllItems(listView.m_hWnd);
	if (!this->bitmap)
		return false;
	UINT pocet;
	UINT velikost;
	PropertyItem* propertyItem;
	if (bitmap->GetPropertySize(&velikost, &pocet) != Ok)
		return false;
	if (pocet == 0)
		return false;
	propertyItem = (PropertyItem*)
		HeapAlloc(GetProcessHeap(), 0, velikost);
	if (bitmap->GetAllPropertyItems(
		velikost, pocet, propertyItem) != Ok)
	{
		HeapFree(GetProcessHeap(), 0, propertyItem);
		propertyItem = NULL;
		return false;
	}

	int polozka;
	CString nazev;
	CString hodnota;
	for (int i = 0; i < (int)pocet; i++)
	{
		if (!GetPolozka(propertyItem, i,
			nazev, hodnota))
			continue;
		polozka = PridatPolozkuSeznamu(nazev.GetBuffer(), i);
		SetTextPolozky(polozka, hodnota.GetBuffer());
	}

	HeapFree(GetProcessHeap(), 0, propertyItem);
	return true;
}


void ZjednodusitZlomek(int& mensi, int& vetsi)
{
	// zkusit pmou dlitelnost
	if (vetsi%mensi == 0)
	{
		vetsi = vetsi/mensi;
		mensi = 1;
		return;
	}
	// zat a od poloviny
	int delitel = mensi / 2;
	while (delitel > 1)
	{
		if (mensi % delitel != 0)
		{
			delitel--;
			continue;
		}
		if (vetsi % delitel != 0)
		{
			delitel--;
			continue;
		}
		mensi /= delitel;
		vetsi /= delitel;
		return;
	}
}

bool GetPolozka(PropertyItem* propertyItem,
	int index, CString& nazev, CString& hodnota)
{
	sRational rational;

	CStringA strA;
	switch (propertyItem[index].id)
	{
	case PropertyTagExifExposureTime:
		nazev = L"Expozice";
		return GetHodnotaExpozice(propertyItem, index, hodnota);
		break;
	case PropertyTagExifFNumber:
		nazev = L"Clona";
		return GetHodnotaClona(propertyItem, index, hodnota);
        break;
	case PropertyTagExifExposureProg:
		nazev = L"Program expozice";
		return GetHodnotaProgramExpozice(propertyItem,
			index, hodnota);
		break;
	case PropertyTagExifISOSpeed: // short
		nazev = L"ISO";
		hodnota.Format(L"%d",
			(int)(*(short*)propertyItem[index].value));
		break;
	case PropertyTagExifDTDigitized: // text
		nazev = L"Vytvoeno";
		hodnota = CString((char*)propertyItem[index].value);
		break;
	case PropertyTagExifAperture: // trbina 
		nazev = L"Zvrka";
		memcpy(&rational,
			(BYTE*)propertyItem[index].value, sizeof(rational));
		hodnota.Format(L"%.3f",
			(float)rational.long1/rational.long2);
		break;
	case PropertyTagExifBrightness: // text
		nazev = L"Jas";
		memcpy(&rational,
			(BYTE*)propertyItem[index].value, sizeof(rational));
		hodnota.Format(L"%.3f",
			(float)rational.long1/rational.long2);
		break;
	case PropertyTagExifExposureBias: // expozice
		nazev = L"Expozice";
		memcpy(&rational,
			(BYTE*)propertyItem[index].value, sizeof(rational));
		hodnota.Format(L"%.3f",
			(float)rational.long1/rational.long2);
		break;
	case PropertyTagExifMaxAperture: // max. clozna
		nazev = L"Max. clona";
		memcpy(&rational,
			(BYTE*)propertyItem[index].value, sizeof(rational));
		hodnota.Format(L"%.3f",
			(float)rational.long1/rational.long2);
		break;
	case PropertyTagExifMeteringMode: // metoda men, short
		nazev = L"Metoda men";
		return GetHodnotaMetodaMereni(propertyItem,
			index, hodnota);
		break;
	case PropertyTagExifLightSource: // zdroj svtla
		nazev = L"Zdroj zvtla";
		return GetHodnotaZdrojSvetla(propertyItem,
			index, hodnota);
		break;
	case PropertyTagExifFlash: // blesk
		nazev = L"Blesk";
		return GetHodnotaBlesk(propertyItem,
			index, hodnota);
		break;
	case PropertyTagExifFocalLength: // blesk
		nazev = L"Ohniskov vzdlenost";
		memcpy(&rational, (BYTE*)
			propertyItem[index].value, sizeof(rational));
		hodnota.Format(L"%.2f mm",
			(float)rational.long1/rational.long2);
		break;

	case PropertyTagImageDescription: // popis
		nazev = L"Popis obrzku";
		hodnota = CString((char*)propertyItem[index].value);
		break;
	case PropertyTagEquipModel: // zazen
		nazev = L"Fotoapart";
		hodnota = CString((char*)propertyItem[index].value);
		break;
	case PropertyTagArtist: // autor
		nazev = L"Autor";
		hodnota = CString((char*)propertyItem[index].value);
		break;
	case PropertyTagThumbnailWidth:
		nazev = L"ka nhledu";
		hodnota.Format(L"%d",
			(int)*((long*)propertyItem[index].value));
		break;
	case PropertyTagCopyright:
		nazev = L"Copyright";
		hodnota = CString((char*)propertyItem[index].value);
		break;
	default:
		return false;
	}
	return true;
}

bool GetHodnotaExpozice(PropertyItem* propertyItem,
	int index, CString& text)
{
	LONG l1;
	LONG l2;
	memcpy(&l1, (BYTE*)
		propertyItem[index].value, sizeof(LONG));
	memcpy(&l2, (BYTE*)
		propertyItem[index].value + sizeof(LONG), sizeof(LONG));
	if (l1 > l2)
	{
		ZjednodusitZlomek((int&)l2, (int&)l1);
		text.Format(L"%d/%d sec.", (int)l2, (int)l1);
	}
	else
	{
		ZjednodusitZlomek((int&)l1, (int&)l2);
		text.Format(L"%d/%d sec.", (int)l1, (int)l2);
	}
	return true;
}

bool GetHodnotaBlesk(PropertyItem* propertyItem,
	int index, CString& text)
{
	short hodnota = 
		(short)*((short*)propertyItem[index].value);
	if (hodnota & 0x0001)
		text = L"S bleskem";
	else
		text = L"Bez blesku";
	switch (hodnota & 0x0006)
	{
	case 10:
		MessageBeep(0);
		break;
	}
	return true;
}

bool GetHodnotaZdrojSvetla(PropertyItem* propertyItem,
	int index, CString& text)
{
	switch ((short)*((short*)propertyItem[index].value))
	{
	case 0:
		text = L"Neznm";
		break;
	case 1:
		text = L"Denn svtlo";
		break;
	case 2:
		text = L"Fluorescenn";
		break;
	case 3:
		text = L"Tungsten";
		break;
	case 17:
		text = L"Standardn svtlo A";
		break;
	case 18:
		text = L"Standardn svtlo B";
		break;
	case 19:
		text = L"Standardn svtlo C";
		break;
	case 20:
		text = L"D55";
		break;
	case 21:
		text = L"D65";
		break;
	case 22:
		text = L"D75";
		break;
	default:
		text = L"neureno";
		return false;
		break;
	}
	return true;
}

bool GetHodnotaClona(PropertyItem* propertyItem,
	 int index, CString& text)
{
	LONG l1;
	LONG l2;
	memcpy(&l1, (BYTE*)
		propertyItem[index].value, sizeof(LONG));
	memcpy(&l2, (BYTE*)
		propertyItem[index].value + sizeof(LONG), sizeof(LONG));
	if (l1 > l2)
	{
		text.Format(L"%.1f", (float)l1/l2);
	}
	else
	{
		ZjednodusitZlomek((int&)l1, (int&)l2);
		text.Format(L"%d/%d", (int)l1, (int)l2);
	}
	return true;
}


bool GetHodnotaProgramExpozice(PropertyItem* propertyItem,
	int index, CString& text)
{
	switch ((short)*((short*)propertyItem[index].value))
	{
	case 1:
		text = L"Manuln";
		break;
	case 2:
		text = L"Normln";
		break;
	case 3:
		text = L"Priorita clony";
		break;
	case 4:
		text = L"Priorita expozice";
		break;
	case 5:
		text = L"Kreativn program";
		break;
	case 6:
		text = L"Akn program";
		break;
	case 7:
		text = L"Reim portrt";
		break;
	case 8:
		text = L"Reim krajina";
		break;
	default:
		text = "Nedefinovno";
		break;

	}
	return true;
}

bool GetHodnotaMetodaMereni(PropertyItem* propertyItem,
	int index, CString& text)
{
	switch ((short)*((short*)propertyItem[index].value))
	{
	case 0:
		text = L"Neznm";
		break;
	case 1:
		text = L"Prmr";
		break;
	case 2:
		text = L"Zdraznn stedu";
		break;
	case 3:
		text = L"Bodov";
		break;
	case 4:
		text = L"Vcebodov";
		break;
	case 5:
		text = L"Rastr";
		break;
	case 6:
		text = L"st";
		break;
	}
	return true;
}

bool GetHodnotaText(PropertyItem* propertyItem,
	int index, CString& text)
{
#pragma warning(push)
#pragma warning(disable: 4311)
	if (!bitmap)
		return false;
	if (bitmap->GetLastStatus() != Ok)
		return false;
	CStringA textA;
	LONG l1;
	LONG l2;
	switch (propertyItem[index].type)
	{
	case PropertyTagTypeASCII:
		textA.Format("%s", propertyItem[index].value);
		text = CString(textA.GetBuffer());
		break;
	case PropertyTagTypeByte: //  8 bitov slo
		text.Format(L"%d",
			(int)propertyItem[index].value);
		break;
	case PropertyTagTypeLong: // 32 bit. slo
		text.Format(L"%d",
			(int)propertyItem[index].value);
		break;
	case PropertyTagTypeRational: // dv sla LONG
		memcpy(&l1, (BYTE*)
			propertyItem[index].value, sizeof(LONG));
		memcpy(&l2, (BYTE*)
			propertyItem[index].value + sizeof(LONG), sizeof(LONG));
		if (l1 > l2)
		{
			ZjednodusitZlomek((int&)l2, (int&)l1);
			text.Format(L"%d/%d", (int)l2, (int)l1);
		}
		else
		{
			ZjednodusitZlomek((int&)l1, (int&)l2);
			text.Format(L"%d/%d", (int)l1, (int)l2);
		}
		break;
	case PropertyTagTypeShort: // 16 bit. slo
		text.Format(L"%d", (int)propertyItem[index].value);
		break;
	case PropertyTagTypeSLONG: // 32 bit. slo se znamnkem
		text.Format(L"%d", (int)propertyItem[index].value);
		break;
	case PropertyTagTypeSRational: // 2 sla SLONG
		memcpy(&l1, (BYTE*)
			propertyItem[index].value, sizeof(LONG));
		memcpy(&l2, (BYTE*)
			propertyItem[index].value + sizeof(LONG), sizeof(LONG));
		if (l1 > l2)
		{
			ZjednodusitZlomek((int&)l2, (int&)l1);
			text.Format(L"%d/%d", (int)l2, (int)l1);
		}
		else
		{
			ZjednodusitZlomek((int&)l1, (int&)l2);
			text.Format(L"%d/%d", (int)l1, (int)l2);
		}
		break;
	case PropertyTagTypeUndefined:
		break;
	}
	return true;
#pragma warning(pop)
}

void ZavritSoubor()
{
	ListView_DeleteAllItems(listView.m_hWnd);
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

LRESULT OnZavrit(WORD, WORD, HWND, BOOL&)
{
	ZavritSoubor();
	RedrawWindow();
	return 0;
}

};

Aplikace _aplikace;



extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR cmdLine, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}
