/****************************************************
Soubor: DataBitmapy.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "resource.h"
#include "DataBitmapy.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl < Aplikace >
{
public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)(COLOR_WINDOW + 1),
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"UpravaDatBitmapy",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}

	DECLARE_LIBID(LIBID_ATLLib)

public:
	ULONG_PTR gdiplusToken;
	Bitmap* bitmap;
	wchar_t soubor[MAX_PATH];
	CString jmeno;

public:
	Aplikace()
	{
		this->bitmap = NULL;
		wcscpy_s(this->soubor,
			_countof(this->soubor), L"");
	}

	~Aplikace()
	{
		if (this->bitmap)
			delete this->bitmap;
	}

public:
	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_CLOSE, OnClose)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_KOSTKY, OnKostky)
		COMMAND_ID_HANDLER(ID_NEGATIV, OnNegativ)
		COMMAND_ID_HANDLER(ID_OTEVRIT, OnOtevrit)
		COMMAND_ID_HANDLER(ID_STUPNE_SEDE, OnStupneSede)
		COMMAND_ID_HANDLER(ID_ULOZIT, OnUlozit)
		COMMAND_ID_HANDLER(ID_ZAVRIT, OnZavrit)
	END_MSG_MAP()

HRESULT PreMessageLoop(int nShowCmd)
{
	CAtlExeModuleT<Aplikace>::PreMessageLoop(nShowCmd);
	Lock();

	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	if (!Vytvorit())
		return E_HANDLE;
	return S_OK;
}


HRESULT PostMessageLoop()
{
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return CAtlExeModuleT<Aplikace>::PostMessageLoop();
}

void Chyba(const wchar_t* text)
{
	MessageBox(text, jmeno,
		MB_ICONERROR | MB_SETFOREGROUND);
}

bool Vytvorit()
{
	jmeno.LoadString(IDS_PROJNAME);
	RECT rect = {0, 0, 800, 600};
	if (!Create(NULL, rect, jmeno,
		WS_OVERLAPPEDWINDOW))
		return false;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return true;
}

LRESULT OnClose(UINT, WPARAM, LPARAM, BOOL&)
{
	ZavritSoubor();
	return DefWindowProc();
}

LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT OnOtevrit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = OFN_FILEMUSTEXIST;
	if (!GetOpenFileName(&ofn))
		return 0;
	ZavritSoubor();
	this->bitmap = new Bitmap(soubor);
	if (bitmap->GetLastStatus() != Ok)
	{
		delete bitmap;
		bitmap = NULL;
		wcscpy_s(this->soubor,
			_countof(this->soubor),	L"");
		return 0;
	}
	RedrawWindow();
	return 0;
}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL& bh)
{
	if (!this->bitmap)
		return DefWindowProc();
	RECT rect;
	GetClientRect(&rect);
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics* graphics = new Graphics(hdc);
	UINT sirka = rect.right;
	UINT vyska = rect.bottom;
	int xPoz = 0;
	int yPoz = 0;
	if ((UINT)sirka < bitmap->GetWidth() ||
		(UINT)vyska < bitmap->GetHeight())
	{
		if ((float)sirka/(float)bitmap->GetWidth() >
			(float)vyska/(float)bitmap->GetHeight())
		{
			sirka = (bitmap->GetWidth()*vyska ) /
				bitmap->GetHeight();
			xPoz = (rect.right - sirka) / 2;
		}
		else
		{
			vyska = (bitmap->GetHeight()*sirka ) /
				bitmap->GetWidth();
			yPoz = (rect.bottom - vyska) / 2;
		}
	}
	else
	{
		sirka = this->bitmap->GetWidth();
		vyska = this->bitmap->GetHeight();
		xPoz = (rect.right - sirka) / 2;
		yPoz = (rect.bottom - vyska) / 2;
	}
	Rect rectCil(xPoz, yPoz, sirka, vyska);
	graphics->DrawImage(bitmap,
		rectCil,
		0, 0,
		bitmap->GetWidth(),
		bitmap->GetHeight(),
		UnitPixel);
	delete graphics;
	EndPaint(&ps);
	bh = TRUE;
	return 0;
}

void ZavritSoubor()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

LRESULT OnZavrit(WORD, WORD, HWND, BOOL&)
{
	ZavritSoubor();
	RedrawWindow();
	return 0;
}

LRESULT OnNegativ(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 3));
	while (pData < pKonec)
	{
		*pData = 0xFF - *pData;
		*(pData+1) = 0xFF - *(pData+1);
		*(pData+2) = 0xFF - *(pData+2);
		pData+=3;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

LRESULT OnStupneSede(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bData.Scan0 + (bData.Height * bData.Width * 3));
	BYTE b;
	while (pData < pKonec)
	{
		b = ((11 * (*(pData+2)) + 59 *
			(*(pData+1))+ 30 * (*(pData)))) / 100;
		*(pData) = b;
		*(pData + 1) = b;
		*(pData + 2) = b;
		pData += 3;
	}
	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

// Pedpokld formt 3 byte/pixel
__forceinline BYTE* PixelBitmapy(BitmapData* bd, int x, int y)
{
	return (BYTE*)bd->Scan0 +
		y * bd->Stride +
		x * 3;
}

LRESULT OnKostky(WORD, WORD, HWND, BOOL&)
{
	if (!this->bitmap)
		return 0;
	int velikostKostky = 32;
	BitmapData bData;
	this->bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat24bppRGB, &bData);
	BYTE* pData = (BYTE*)bData.Scan0;
	BYTE* pixel;
	int cervena = 0;
	int modra = 0;
	int zelena = 0;
	int x;
	int y;
	int xx;
	int yy;
	for (x = 0; x < (int)bData.Width/2; x += velikostKostky)
		for (y = 0; y < (int)bData.Height/2; y += velikostKostky)
		{
			cervena = 0;
			modra = 0;
			zelena = 0;
			for (xx = x; xx < x + velikostKostky; xx++)
				for (yy = y; yy < y + velikostKostky; yy++)
				{
					pixel = PixelBitmapy(&bData, xx, yy);
					modra += *pixel;
					zelena += *(pixel+1);
					cervena += *(pixel+2);
				}
			modra /= velikostKostky * velikostKostky;
			cervena /= velikostKostky * velikostKostky;
			zelena /= velikostKostky * velikostKostky;
			for (xx = x; xx < x + velikostKostky; xx++)
				for (yy = y; yy < y + velikostKostky; yy++)
				{
					pixel = PixelBitmapy(&bData, xx, yy);
					*pixel = (BYTE)modra;
					*(pixel + 1) = (BYTE)zelena;
					*(pixel + 2) = (BYTE)cervena;
				}
		}


	bitmap->UnlockBits(&bData);
	RedrawWindow();
	return 0;
}

int GetEncoderClsidPripona(const wchar_t* priponaSouboru,
	CLSID* pClsid)
{
	CString strPripona = CString(priponaSouboru);
	strPripona.MakeUpper();
	UINT pocet = 0; // poet grafickch enkodr
	UINT velikost = 0; // velikost pole obrazovch enkodr
	ImageCodecInfo* pImageCodecInfo = NULL;
	GetImageEncodersSize(&pocet, &velikost);
	if (velikost == 0)
		return -1;  // Chyba
	pImageCodecInfo =
		(ImageCodecInfo*)(malloc(velikost));
	if (!pImageCodecInfo)
		return -1;  // Chyba
	GetImageEncoders(pocet, velikost, pImageCodecInfo);
	for (UINT i = 0; i < pocet; i++)
	{
		if (wcsstr(pImageCodecInfo[i].FilenameExtension,
			strPripona.GetBuffer()) != NULL)
		{
			*pClsid = pImageCodecInfo[i].Clsid;
			free(pImageCodecInfo);
			return i;  // V podku
		}    
	}
	free(pImageCodecInfo);
	return -1; // Chyba
}

LRESULT OnUlozit(WORD, WORD, HWND, BOOL&)
{
	OPENFILENAME ofn;
	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.lpstrFile = this->soubor;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = (HWND)m_hWnd;
	ofn.lpstrFilter = L"Grafick soubory\0"
		L"*.bmp;*.jpg;*.tiff;"
		L"*.png;*.gif;*.jpeg\0"
		L"Vechny soubory\0"
		L"*.*\0";
	ofn.nFilterIndex = 1;
	ofn.Flags = 0;
	if (!GetSaveFileName(&ofn))
		return 0;
	CLSID clsid;
	if (GetEncoderClsidPripona(PathFindExtensionW(
		this->soubor), &clsid) < 0)
	{
		Chyba(L"Nepodailo se nalzt kodek");
		return 0;
	}
	if (this->bitmap->Save(this->soubor, &clsid) != Ok)
		Chyba(L"Pi ukldn dolo k chyb");
	return 0;
}

};

Aplikace _AtlModule;

// hlavn funkce programu pro Windows
extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _AtlModule.WinMain(nShowCmd);
}

