/****************************************************
Soubor: Barvy.cpp
(C) 2006 Radek Chalupa - www.radekchalupa.cz
*****************************************************/

#include "stdafx.h"
#include "resource.h"

class Aplikace : public CAtlExeModuleT< Aplikace >,
	public CWindowImpl< Aplikace >
{
public :
	DECLARE_LIBID(LIBID_ATLLib)

public:
	static CWndClassInfo& GetWndClassInfo()
	{
		static CWndClassInfo wc =
		{
			{
				sizeof(WNDCLASSEX),
				CS_DBLCLKS | CS_HREDRAW,
				StartWindowProc,
				0, 0,
				NULL,
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI)),
				(HCURSOR)NULL,
				(HBRUSH)NULL,
				MAKEINTRESOURCE(IDR_HLAVNI), // menu
				L"BarvyDemo",
				(HICON)LoadIcon(_AtlBaseModule.m_hInst,
					MAKEINTRESOURCE(IDI_HLAVNI))
			},
			NULL, // origname
			NULL, // wndproc
			IDC_ARROW, // cursor ID
			TRUE, // system cursor
			0, // atom
			L""
		};
		return wc;
	}
public:
	CString jmeno;
	ULONG_PTR gdiplusToken;
	Bitmap* bitmap;
	HBRUSH hbrushPozadi;

	Aplikace()
	{
		this->bitmap = NULL;
	}

public:
	BEGIN_MSG_MAP(Aplikace)
		MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
		MESSAGE_HANDLER(WM_LBUTTONUP, OnLButtonUp)
		MESSAGE_HANDLER(WM_PAINT, OnPaint)
		COMMAND_ID_HANDLER(ID_BAREVNY_PRECHOD, OnBarevnyPrechod)
		COMMAND_ID_HANDLER(ID_BARVY, OnBarvy)
		COMMAND_ID_HANDLER(ID_KONEC, OnKonec)
		COMMAND_ID_HANDLER(ID_VYBRAT_PRUHLEDNOU_BARVU, OnVybratPruhlednouBarvu)
		COMMAND_ID_HANDLER(ID_PRIDAT_PRUHLEDNOU_BARVU, OnVybratPruhlednouBarvu)
	END_MSG_MAP()

LRESULT OnDestroy(UINT, WPARAM, LPARAM, BOOL&)
{
	PostQuitMessage(0);
	return DefWindowProc();
}

LRESULT OnPaint(UINT, WPARAM, LPARAM, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	PAINTSTRUCT ps;
	HDC hdc = BeginPaint(&ps);
	Graphics gr(hdc);
	CachedBitmap* cb;
	cb = new CachedBitmap(this->bitmap, &gr);
	gr.DrawCachedBitmap(cb, 0, 0);
	delete cb;
	return 0;
}

HRESULT PreMessageLoop(int nShowCmd)
{
	__super::PreMessageLoop(nShowCmd);

	Lock();
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_WIN95_CLASSES |
		ICC_USEREX_CLASSES | ICC_COOL_CLASSES |
		ICC_BAR_CLASSES | ICC_INTERNET_CLASSES |
		ICC_NATIVEFNTCTL_CLASS |
		ICC_TAB_CLASSES | ICC_ANIMATE_CLASS;
	if (!InitCommonControlsEx(&icc))
		return E_FAIL;

	jmeno.LoadString(IDS_PROJNAME);

	GdiplusStartupInput gdiplusStartupInput;
	if (GdiplusStartup(&gdiplusToken,
		&gdiplusStartupInput, NULL) != Ok)
		return E_FAIL;
	
	RECT rect = { 0, 0, 600, 400 };
	if (!Create(NULL, rect, jmeno, WS_OVERLAPPED |
		WS_SYSMENU | WS_MINIMIZEBOX | WS_BORDER, 0))
		return E_FAIL;
	hbrushPozadi = CreatePatternBrush(
		LoadBitmap(_AtlBaseModule.m_hInst,
		MAKEINTRESOURCE(IDB_POZADI)));
	SetClassLongPtr(m_hWnd, GCLP_HBRBACKGROUND,
		(LONG)hbrushPozadi);
	BOOL bh = TRUE;
	CenterWindow();
	ShowWindow(SW_SHOW);
	return S_OK;
}

HRESULT PostMessageLoop()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
	if (hbrushPozadi)
	{
		DeleteObject(hbrushPozadi);
		hbrushPozadi = NULL;
	}
	GdiplusShutdown(gdiplusToken);
	Unlock();
	return __super::PostMessageLoop();
}

void __forceinline ZrusitBitmapu()
{
	if (this->bitmap)
	{
		delete this->bitmap;
		this->bitmap = NULL;
	}
}

LRESULT OnKonec(WORD, WORD, HWND, BOOL&)
{
	PostMessage(WM_CLOSE);
	return 0;
}

LRESULT OnBarevnyPrechod(WORD, WORD, HWND, BOOL&)
{
	RECT rect;
	GetClientRect(&rect);
	ZrusitBitmapu();
	this->bitmap = new Bitmap(rect.right, rect.bottom, PixelFormat32bppARGB);
	Graphics* gr = Graphics::FromImage(this->bitmap);
	LinearGradientBrush br(Point(0, 0),
		Point(this->bitmap->GetWidth(), 0),
//		Color(0,0,0), Color(0xFF, 0xFF, 0xFF));
		Color(0,0,0), Color(0xFF, 0xFF, 0xFF));
	gr->FillRectangle(&br, 0, 0,
		this->bitmap->GetWidth(),
		this->bitmap->GetHeight());
	delete gr;
	RedrawWindow();
	return 0;
}

LRESULT OnBarvy(WORD, WORD, HWND, BOOL&)
{
	RECT rect;
	GetClientRect(&rect);
	ZrusitBitmapu();
	int xPoz = 0;
	const int krok = rect.right / 8;
	this->bitmap = new Bitmap(rect.right, rect.bottom, PixelFormat32bppARGB);
	Graphics* gr = Graphics::FromImage(this->bitmap);
	SolidBrush* brush = new SolidBrush(Color(0, 0, 0xFF));
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0xFF, 0, 0));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0, 0xFF, 0));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0xFF, 0xFF, 0));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0, 0xFF, 0xFF));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0xFF, 0, 0xFF));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0xFF, 0xFF, 0xFF));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	brush = new SolidBrush(Color(0, 0, 0));
	xPoz += krok;
	gr->FillRectangle(brush, xPoz, 0,
		krok,
		this->bitmap->GetHeight());
	delete brush;
	delete gr;
	RedrawWindow();
	return 0;
}

void NastavitPruhlednouBarvu(COLORREF barva, bool pridat)
{
	if (!this->bitmap)
		return;
	BitmapData bitmapData;
	if (bitmap->LockBits(&Rect(0, 0,
		bitmap->GetWidth(), bitmap->GetHeight()),
		ImageLockModeWrite | ImageLockModeRead,
		PixelFormat32bppARGB, &bitmapData) != Ok)
		return;
	BYTE* pData = (BYTE*)bitmapData.Scan0;
	BYTE* pKonec = (BYTE*)((BYTE*)
		bitmapData.Scan0 + (bitmapData.Height * bitmapData.Width * 4));
	BYTE r = GetRValue(barva);
	BYTE g = GetGValue(barva);
	BYTE b = GetBValue(barva);
	while (pData < pKonec)
	{
		if (*pData == b && *(pData+1) == g && *(pData+2) == r)
			*(pData+3) = 100;
		else
		{
			if (!pridat)
				*(pData+3) = 255;
		}

		pData += 4;
	}
	bitmap->UnlockBits(&bitmapData);
	RedrawWindow();
}

LRESULT OnVybratPruhlednouBarvu(WORD, WORD wID, HWND, BOOL&)
{
	CHOOSECOLOR cc;
	static COLORREF crVychozi[16] = 
	{
		0x00000000,
		0x00FFFFFF,
		0x00FF0000,
		0x0000FF00,
		0x000000FF,
		0x00FF00FF,
		0x00FFFF00,
		0x0000FFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
		0x00FFFFFF,
	};
	memset(&cc, 0, sizeof(cc));
	cc.lStructSize = sizeof(cc);
	cc.lpCustColors = crVychozi;
	cc.hwndOwner = m_hWnd;
	cc.Flags = CC_FULLOPEN;
	if (!ChooseColor(&cc))
		return 0;
	NastavitPruhlednouBarvu(cc.rgbResult,
		wID == ID_VYBRAT_PRUHLEDNOU_BARVU ? false : true);
	RedrawWindow();
	return 0;
}

LRESULT OnLButtonUp(UINT, WPARAM, LPARAM lparam, BOOL&)
{
	if (!this->bitmap)
		return DefWindowProc();
	HDC hdc = GetDC();
	COLORREF cr = GetPixel(hdc,
		LOWORD(lparam), HIWORD(lparam));
	NastavitPruhlednouBarvu(cr, (GetAsyncKeyState(VK_CONTROL) < 0));
	ReleaseDC(hdc);
	LRESULT lr = DefWindowProc();
	RedrawWindow();
	return lr;
}

};

Aplikace _aplikace;

extern "C" int WINAPI _tWinMain(HINSTANCE,
	HINSTANCE, LPTSTR, int nShowCmd)
{
    return _aplikace.WinMain(nShowCmd);
}

