% Funkce Tazenimysi03
% pokus o ovladani dvou spojitych 2D grafu
% bod ma funkci polu prenosove funkce linearniho obvodu 1. radu
% vytvoreno 16.10.2003
% ----------------------------------------------------------------------------
function Tazenimysi03(vstpar)
   global PolohaAxes Xplot Yplot Xmodul Ymodul Xbod Ybod Xlimit Ylimit Detekce h1 Mysuvolnena 
   global Xosa1 Yosa1 Xdist Ydist
   if nargin==0
      %------------------- kresleni grafickych objektu Figure a Uicontrol ---------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
      Monitor=get(0,'ScreenSize'); % rozliseni obrazovky monitoru
      F1=figure('Units','Pixels','Name','Spojit 2D graf .1',... % vlastni vykresleni objektu Figure
                'Position',[0.37*Monitor(3) 0.208*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure1','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');
      F2=figure('Units','Pixels','Name','Spojit 2D graf .2',... % vlastni vykresleni objektu Figure
                'Position',[0.675*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure2','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');
      F3=figure('Units','Pixels','Name','Spojit 2D graf .3',... % vlastni vykresleni objektu Figure
                'Position',[0.065*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure3','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');            
            
      F=figure('Units','Pixels','Name','Hlavn obrzek',... % Figure pro spojity graf
               'Position',[0.37*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
               'Tag','Figure','Color',[0.9 0.7 0.6],...
               'NumberTitle','off','Resize','on','Menubar','none');
      A=axes('Units','Pixels',... % vlastni vykresleni objektu Figure
             'Position',[50 100 400 170],'Tag','Axes','Color','white');
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor On
                'Position',[0.13 0.03 0.16 0.08],'Tag','textcursoron',...
                'String','Cursor On','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor On
                'Position',[0.1 0.04 0.03 0.08],'Tag','radiocursoron',...
                'CallBack','Tazenimysi03 radiocursoron','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor Off
                'Position',[0.5 0.03 0.16 0.08],'Tag','textcursoroff',...
                'String','Cursor Off','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor Off
                'Position',[0.47 0.04 0.03 0.08],'Tag','radiocursoroff','Value',1,...
                'CallBack','Tazenimysi03 radiocursoroff','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose x
                'Position',[0.1 0.10 0.25 0.1],'Tag','text1',...
                'CallBack','Tazenimysi03 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose y
                'Position',[0.40 0.10 0.35 0.1],'Tag','text2',...
                'CallBack','Tazenimysi03 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice bodu nahore
                'Position',[0.12 0.925 0.3 0.05],'Tag','text3',...
                'CallBack','Tazenimysi03 text','ForegroundColor','black','String','Souadnice bodu:',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Edit',...   % edit pro vypis souradnic bodu, osa x
                'Position',[0.41 0.91 0.2 0.08],'Tag','edit1',...
                'CallBack','Tazenimysi03 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Edit',...   % % edit pro vypis souradnic bodu, osa y
                'Position',[0.63 0.91 0.2 0.08],'Tag','edit2',...
                'CallBack','Tazenimysi03 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Push',...   % tlacitko Konec
                'Position',[0.81 0.05 0.16 0.15],'Tag','konec',...
                'String','Konec','CallBack','Tazenimysi03 konec','ForegroundColor','black',...
                'BackgroundColor','yellow','FontWeight','bold','FontSize',14);
  %-------------- Vykresleni bodu -------------
      %figure(F)
      Xbod=-100;
      Ybod=0; % jeden zaporny realny pol
      Xlimit=10; % lokalizacni vzdalenost v ose x
      Ylimit=Xlimit; % lokalizacni vzdalenost v ose y
      h1=plot(Xbod,Ybod,'ro');
      set(gca,'Xtick',0,'Ytick',0)
      grid on
      set(h1,'Markersize',4)
      set(h1,'LineWidth',3)
      set(h1,'HitTest','off') % aby se daly odecist souradnice, kdyz je pointer primo na krouzku
      axis([-1000 100 -10 10])
      Detekce=0; % bod nebyl implicitne vybran
      Mysuvolnena=0; % pro pozdejsi uvolneni talcitka mysi
      set(findobj('Tag','edit1'),'String',Xbod) % vypsani souradnice bodu v ose x v editacnim poli
      set(findobj('Tag','edit2'),'String',Ybod) % vypsani souradnice bodu v ose y v editacnim poli
      graf1(Xbod) % volani dalsi funkce pro 2D graf c.1, pocatecni kresleni
      graf2(Xbod) % volani dalsi funkce pro 2D graf c.2, pocatecni kresleni
      graf3(Xbod) % volani dalsi funkce pro 2D graf c.3, pocatecni kresleni
      figure(F) % aktivni je Figure
   %------------------------------- reakce na Callback -------------------------------------------
   %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO000000
   else 
      switch(vstpar) 
        case('radiocursoron') % aktivace kurzoru, reakce na pohyb pointeru mysi
           set(findobj('Tag','radiocursoroff'),'Value',0) % deaktivace radio Curson Off
           set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi03 pohyb') % reakce na pohyb     po Figure
           figure(findobj('Tag','Figure')); % aktivace Figure (kdyby jich bylo vice)
              set(gca,'ButtonDownFcn','Tazenimysi03 klik+') % reakce na stisk mysi v ramci Axes
              set(gcf,'WindowButtonUpFcn','Tazenimysi03 klik-') % reakce na uvolneni mysi v ramci Axes
           PolohaAxes=get(gca,'Position'); % pozice Axes v ramci Figure
           Xplot=get(gca,'Xlim'); % min a max na vodorovne ose Plot
           Yplot=get(gca,'Ylim'); % min a max na svisle ose Plot
           Xmodul=(Xplot(2)-Xplot(1))/PolohaAxes(3); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose x
           Ymodul=(Yplot(2)-Yplot(1))/PolohaAxes(4); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose y
           set(h1,'EraseMode','xor') % pro prekereslovani dale
       case('radiocursoroff') % deaktivace kurzoru
           set(findobj('Tag','radiocursoron'),'Value',0) % deaktivace radio Curson On
           set(findobj('Tag','Figure'),'Pointer','arrow') % v ramci Figure nastavi tvar pointeru zpet na sip
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn',' ') % deaktivace
           set(findobj('Tag','text1'),'String',' '); % zmizeni souradnic
           set(findobj('Tag','text2'),'String',' '); % zmizeni souradnic
       case('pohyb')
           %--- zjisteni souradnic v ramxi Axes ---
           Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
           Xosa=Souradnice(1); % x-ova souradnice
           Yosa=Souradnice(2); % y-ova souradnice           
           Xosa1=Xosa-PolohaAxes(1); % aby 0 byla na zacastku Axes a ne Figure
           Yosa1=Yosa-PolohaAxes(2); % aby 0 byla na zacastku Axes a ne Figure
           %--- Osetreni zapornych poloh a maxim na obou osach v ramci Axes  ---
           if ((Xosa1>=0)&(Yosa1>=0))&((Xosa1<=PolohaAxes(3)))&(Yosa1<=PolohaAxes(4))
              %--- prepocet souradnic z meritka Axes na poradova cisla dat grafu -----
              Xosa1=Xmodul*Xosa1+Xplot(1); % numericka podoba souradnice v ose x
              %Yosa1=Ymodul*Yosa1+Yplot(1); % numericka podoba souradnice v ose y
              Yosa1=0; % pohyb bodu jen po vodorovne ose
              set(findobj('Tag','text1'),'String',num2str(Xosa1)); 
              set(findobj('Tag','text2'),'String',num2str(Yosa1));
              % --- zmena barvy bodu pri priblizeni ----
              Xdist=abs(Xosa1-Xbod); % vzalenost od krouzku v ose x
              Ydist=abs(Yosa1-Ybod); % vzalenost od krouzku v ose y
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 set(h1,'Color','blue')
              elseif (Xdist>Xlimit)|(Ydist>Ylimit)
                 set(h1,'Color','red') 
              end
              %XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              % --- reakce pri vyberu bodu mysi --------------------------------------
              if (Detekce==1)&(Mysuvolnena==0) % bod vybran mysi, mys zatim neuvolnena
                 Xbod=Xosa1; % nova pozice bodu v ose x
                 Ybod=Yosa1; % nova pozice bodu v ose y    
                 hold on
                 set(h1,'Xdata',Xosa1,'Ydata',0) % bod se bude pohybovat po vodorovne ose
                 %--------------------------------------------------------------------
                 %QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ
                 % --- ovladani spojiteho 2D grafu c. 3 tazenim mysi -----------------
                 w0=abs(Xbod); % novy mezni kruhovy kmitocet obvodu (podle polohy krouzku)
                 Maticegraf=get(findobj('Tag','Figure3'),'UserData'); % Handle plotu z funkce "graf"
                 h4=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 t=Maticegraf(2,:); % osa kruhoveho kmitoctu
                 g=w0*exp(-w0*t); % impulzni odezva pro nove w0
                 %set(get(h4,'parent'),'Xtick',1/w0,'Ytick',0) % zmena polohy casove konstanty jako Xtick
                 %hold on
                 set(h4,'EraseMode','xor')
                 set(h4,'Ydata',g)
                 %drawnow
                 % --- ovladani spojiteho 2D grafu c. 1 tazenim mysi -----------------
                 w0=abs(Xbod); % novy mezni kruhovy kmitocet obvodu (podle polohy krouzku)
                 Maticegraf=get(findobj('Tag','Figure1'),'UserData'); % Handle plotu z funkce "graf"
                 h2=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 w=Maticegraf(2,:); % osa kruhoveho kmitoctu
                 p=i*w; % komplexni kmitocet cerveneho bodu (pol)
                 K=w0./(p+w0); % komplexni kmitoctova charakterisktika
                 Kmod=abs(K); % modulova kmitoctova charakterisktika
                 KmoddB=20*log10(Kmod); % modulova kmitoctova charakterisktika v dB
                 Kfaze=180/pi*angle(K); % fazova kmitoctova charakterisktika
                 %hold on
                 set(h2,'EraseMode','xor')
                 set(h2,'Ydata',KmoddB)
                 %drawnow
                   % --- ovladani spojiteho 2D grafu c. 2 tazenim mysi -----------------
                 w0=abs(Xbod); % novy mezni kruhovy kmitocet obvodu (podle polohy krouzku)
                 Maticegraf=get(findobj('Tag','Figure2'),'UserData'); % Handle plotu z funkce "graf"
                 h3=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 w=Maticegraf(2,:); % osa kruhoveho kmitoctu
                 p=i*w; % komplexni kmitocet cerveneho bodu (pol)
                 K=w0./(p+w0); % komplexni kmitoctova charakterisktika
                 Kreal=real(K); % realna cast komplexni kmitoctove charakterisktiky
                 Kimag=imag(K); % imaginarni cast komplexni kmitoctove charakterisktiky
                 hold on
                 set(h3,'EraseMode','xor')
                 set(h3,'Xdata',Kreal)
                 set(h3,'Ydata',Kimag)
                 %drawnow
                 %QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ
                 %--------------------------------------------------------------------
              else   
              end
              %XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              %-----------------------------------------------------------------------
           else % jedna z os je zaporna, tedy mimo Axes, neudela se nic
           end
        case('klik+') % reakce na stisk tlacitka mysi
              % --- test, zda je pointer blizko krouzku ---
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 Detekce=1;
              else % mys neni dost blizko bodu
                 Detekce=0;
              end
           %--------------------------------------------
        case('klik-') % reakce na uvolneni tlacitka mysi
            
           if Detekce==1 % bod byl tazen pred uvolnenim mysi
              set(findobj('Tag','edit1'),'String',Xbod)
              set(findobj('Tag','edit2'),'String',Ybod)
              hold off 
              Detekce=0;
           else % bod nebyt prd uvolneni tazen (byl daleko)

           end 
        case('konec')
           close all
      end
  end
  
  %------------ Dalsi funkce v ramci m-souboru ------------------------------------------------------------
  %WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
  function graf1(Xbod) % pocatecni kresleni spojiteho 2D grafu c.1, modulova kmitoctova charakteristika
     figure(findobj('Tag','Figure1'))
     w0=abs(Xbod); % mezni kruhovy kmitocet obvodu
     f=1:10000; % kmitocet na ose nezavisle promenne
     w=2*pi*f; % kruhovy kmitocet na ose nezavisle promenne
     p=i*w; % komplexni kmitocet cerveneho bodu (pol)
     K=w0./(p+w0); % komplexni kmitoctova charakterisktika
     Kmod=abs(K); % modulova kmitoctova charakterisktika
     KmoddB=20*log10(Kmod); % modulova kmitoctova charakterisktika v dB
     %Kfaze=180/pi*angle(K); % fazova kmitoctova charakterisktika
     h2=semilogx(w,KmoddB);
     axis([min(w) max(w) -50 10])
     grid on
     title('Modulova kmitoctova charakteristika DP 1. radu')
     xlabel('{\omega}');
     ylabel('Ku [dB]');
     Maticegraf=zeros(2,length(w));
     Maticegraf(1,1)=h2;
     Maticegraf(2,:)=w;
     %Maticegraf(3,:)=KmoddB;     
     set(findobj('Tag','Figure1'),'UserData',Maticegraf) % uschovani h2,w
  function graf2(Xbod) % pocatecni kresleni spojiteho 2D grafu c.2, Hodograf
     figure(findobj('Tag','Figure2'))
     w0=abs(Xbod); % mezni kruhovy kmitocet obvodu
     f=0:1000; % kmitocet na ose nezavisle promenne
     w=2*pi*f; % kruhovy kmitocet na ose nezavisle promenne
     p=i*w; % komplexni kmitocet cerveneho bodu (pol)
     K=w0./(p+w0); % komplexni kmitoctova charakterisktika
     Kreal=real(K); % realna cast komplexni kmitoctove charakterisktiky
     Kimag=imag(K); % imaginarni cast komplexni kmitoctove charakterisktiky
     h3=plot(Kreal,Kimag);
     axis([-max(Kreal) max(Kreal) min(Kimag) abs(min(Kimag))])
     title('Hodograf DP 1. radu')
     xlabel('Real(K)');
     ylabel('Imag(K)');
     grid on
     set(gca,'Xtick',0,'Ytick',0)     
     Maticegraf=zeros(2,length(Kreal));
     Maticegraf(1,1)=h3;
     Maticegraf(2,:)=w;
     %Maticegraf(3,:)=Kimag;     
     set(findobj('Tag','Figure2'),'UserData',Maticegraf) % uschovani h3,w
  function graf3(Xbod) % pocatecni kresleni spojiteho 2D grafu c.3
     figure(findobj('Tag','Figure3'))
     w0=abs(Xbod); % mezni kruhovy kmitocet obvodu
     t=0:(5/w0)/100:5/w0; % osa casu
     g=w0*exp(-w0*t); % impulzni odezva
     h4=plot(t,g);
     axis([min(t) 5/w0 0 500])
     title('Impulzni odezva DP 1. radu')
     xlabel('t');
     ylabel('g');
     grid on
     set(gca,'Xtick',0,'Ytick',0)     
     Maticegraf=zeros(2,length(t));
     Maticegraf(1,1)=h4;
     Maticegraf(2,:)=t;
        %Maticegraf(3,:)=Kimag;     
     set(findobj('Tag','Figure3'),'UserData',Maticegraf) % uschovani h4,t
     
  %WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW     
  % ------------------------------------ Prikazy k Pointeru -----------------------------------------------     
      %set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
      %set(0,'Pointerlocation',[800 800]) % v ramci Root nastavuje ci odecita souradnice pointeru
      %get(0,'PointerWindow') % vraci Handle okna, kde je pointer aktivni
      %get(0,'Pointerlocation') % vraci v ramci Root souradnice pointeru
      %Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
      %set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi03 pohyb') % vraci Handle objektu, jenz je vybran pointerem
%----------------------------------------------------------------------------------------------------------