% Funkce Tazenimysi02, tazeni bodu mysi, dva ovladane grafy ve dvou Figure
% pokus o ovladani dvou spojitych 2D grafu
% vytvoreno 15.10.2003
% ----------------------------------------------------------------------------
function Tazenimysi02(vstpar)
   global PolohaAxes Xplot Yplot Xmodul Ymodul Xbod Ybod Xlimit Ylimit Detekce h1 Mysuvolnena 
   global Xosa1 Yosa1 Xdist Ydist
   if nargin==0
      %------------------- kresleni grafickych objektu Figure a Uicontrol ---------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
      Monitor=get(0,'ScreenSize'); % rozliseni obrazovky monitoru
      F1=figure('Units','Pixels','Name','Spojit 2D graf .1',... % vlastni vykresleni objektu Figure
                'Position',[0.37*Monitor(3) 0.208*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure1','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');
      F2=figure('Units','Pixels','Name','Spojit 2D graf .2',... % vlastni vykresleni objektu Figure
                'Position',[0.675*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure2','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');
      F3=figure('Units','Pixels','Name','Spojit 2D graf .3',... % vlastni vykresleni objektu Figure
                'Position',[0.065*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
                'Tag','Figure3','Color',[0.9 0.7 0.6],...
                'NumberTitle','off','Resize','on','Menubar','none');            
            
      F=figure('Units','Pixels','Name','Hlavn obrzek',... % Figure pro spojity graf
               'Position',[0.37*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
               'Tag','Figure','Color',[0.9 0.7 0.6],...
               'NumberTitle','off','Resize','on','Menubar','none');
      A=axes('Units','Pixels',... % vlastni vykresleni objektu Figure
             'Position',[50 100 400 170],'Tag','Axes','Color','white');
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor On
                'Position',[0.13 0.03 0.16 0.08],'Tag','textcursoron',...
                'String','Cursor On','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor On
                'Position',[0.1 0.04 0.03 0.08],'Tag','radiocursoron',...
                'CallBack','Tazenimysi02 radiocursoron','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor Off
                'Position',[0.5 0.03 0.16 0.08],'Tag','textcursoroff',...
                'String','Cursor Off','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor Off
                'Position',[0.47 0.04 0.03 0.08],'Tag','radiocursoroff','Value',1,...
                'CallBack','Tazenimysi02 radiocursoroff','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose x
                'Position',[0.1 0.10 0.25 0.1],'Tag','text1',...
                'CallBack','Tazenimysi02 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose y
                'Position',[0.40 0.10 0.35 0.1],'Tag','text2',...
                'CallBack','Tazenimysi02 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice bodu nahore
                'Position',[0.12 0.925 0.3 0.05],'Tag','text3',...
                'CallBack','Tazenimysi02 text','ForegroundColor','black','String','Souadnice bodu:',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Edit',...   % edit pro vypis souradnic bodu, osa x
                'Position',[0.41 0.91 0.2 0.08],'Tag','edit1',...
                'CallBack','Tazenimysi02 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Edit',...   % % edit pro vypis souradnic bodu, osa y
                'Position',[0.63 0.91 0.2 0.08],'Tag','edit2',...
                'CallBack','Tazenimysi02 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Push',...   % tlacitko Konec
                'Position',[0.81 0.05 0.16 0.15],'Tag','konec',...
                'String','Konec','CallBack','Tazenimysi02 konec','ForegroundColor','black',...
                'BackgroundColor','yellow','FontWeight','bold','FontSize',14);
  %-------------- Vykresleni bodu -------------
      %figure(F)
      Xbod=2000;
      Ybod=2000;
      Xlimit=100; % lokalizacni vzadlenost v ose x
      Ylimit=Xlimit; % lokalizacni vzadlenost v ose y
      h1=plot(Xbod,Ybod,'ro');
      set(h1,'Markersize',4)
      set(h1,'LineWidth',3)
      set(h1,'HitTest','off') % aby se daly odecist souradnice, kdyz je pointer primo na krouzku
      axis([100 5000 100 5000])
      Detekce=0; % bod nebyl implicitne vybran
      Mysuvolnena=0; % pro pozdejsi uvolneni talcitka mysi
      set(findobj('Tag','edit1'),'String',Xbod) % vypsani souradnice bodu v ose x v editacnim poli
      set(findobj('Tag','edit2'),'String',Ybod) % vypsani souradnice bodu v ose y v editacnim poli
      graf1(Ybod) % volani dalsi funkce pro 2D graf c.1, pocatecni kresleni
      graf2(Ybod) % volani dalsi funkce pro 2D graf c.2, pocatecni kresleni
      graf3(Ybod) % volani dalsi funkce pro 2D graf c.3, pocatecni kresleni
      figure(F) % aktivni je Figure
   %------------------------------- reakce na Callback -------------------------------------------
   %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO000000
   else 
      switch(vstpar) 
        case('radiocursoron') % aktivace kurzoru, reakce na pohyb pointeru mysi
           set(findobj('Tag','radiocursoroff'),'Value',0) % deaktivace radio Curson Off
           set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi02 pohyb') % reakce na pohyb     po Figure
           figure(findobj('Tag','Figure')); % aktivace Figure (kdyby jich bylo vice)
              set(gca,'ButtonDownFcn','Tazenimysi02 klik+') % reakce na stisk mysi v ramci Axes
              set(gcf,'WindowButtonUpFcn','Tazenimysi02 klik-') % reakce na uvolneni mysi v ramci Axes
           PolohaAxes=get(gca,'Position'); % pozice Axes v ramci Figure
           Xplot=get(gca,'Xlim'); % min a max na vodorovne ose Plot
           Yplot=get(gca,'Ylim'); % min a max na slicle ose Plot
           Xmodul=(Xplot(2)-Xplot(1))/PolohaAxes(3); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose x
           Ymodul=(Yplot(2)-Yplot(1))/PolohaAxes(4); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose y
           set(h1,'EraseMode','xor') % pro prekereslovani dale
       case('radiocursoroff') % deaktivace kurzoru
           set(findobj('Tag','radiocursoron'),'Value',0) % deaktivace radio Curson On
           set(findobj('Tag','Figure'),'Pointer','arrow') % v ramci Figure nastavi tvar pointeru zpet na sip
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn',' ') % deaktivace
           set(findobj('Tag','text1'),'String',' '); % zmizeni souradnic
           set(findobj('Tag','text2'),'String',' '); % zmizeni souradnic
       case('pohyb')
           %--- zjisteni souradnic v ramxi Axes ---
           Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
           Xosa=Souradnice(1); % x-ova souradnice
           Yosa=Souradnice(2); % y-ova souradnice           
           Xosa1=Xosa-PolohaAxes(1); % aby 0 byla na zacastku Axes a ne Figure
           Yosa1=Yosa-PolohaAxes(2); % aby 0 byla na zacastku Axes a ne Figure
           %--- Osetreni zapornych poloh a maxim na obou osach v ramci Axes  ---
           if ((Xosa1>=0)&(Yosa1>=0))&((Xosa1<=PolohaAxes(3)))&(Yosa1<=PolohaAxes(4))
              %--- prepocet souradnic z meritka Axes na poradova cisla dat grafu -----
              Xosa1=Xmodul*Xosa1+Xplot(1); % numericka podoba souradnice v ose x
              Yosa1=Ymodul*Yosa1+Yplot(1); % numericka podoba souradnice v ose y
              set(findobj('Tag','text1'),'String',num2str(Xosa1)); 
              set(findobj('Tag','text2'),'String',num2str(Yosa1));
              % --- zmena barvy bodu pri priblizeni ----
              Xdist=abs(Xosa1-Xbod); % vzalenost od krouzku v ose x
              Ydist=abs(Yosa1-Ybod); % vzalenost od krouzku v ose y
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 set(h1,'Color','blue')
              elseif (Xdist>Xlimit)|(Ydist>Ylimit)
                 set(h1,'Color','red') 
              end
              %XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              % --- reakce pri vyberu bodu mysi --------------------------------------
              if (Detekce==1)&(Mysuvolnena==0) % bod vybran mysi, mys zatim neuvolnena
                 Xbod=Xosa1; % nova pozice bodu v ose x
                 Ybod=Yosa1; % nova pozice bodu v ose y    
                 hold on
                 set(h1,'Xdata',Xosa1,'Ydata',Yosa1)
                 %--------------------------------------------------------------------
                 %QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ
                 % --- ovladani spojiteho 2D grafu c. 1 tazenim mysi -----------------
                 Maticegraf=get(findobj('Tag','Figure1'),'UserData'); % Handle plotu z funkce "graf"
                 h2=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 t1=Maticegraf(2,:); % osa casu
                 u1=Maticegraf(3,:); % osa vertikalni
                 amplituda=round(Yosa1/100);
                 %figure(findobj('Tag','Figure1'))
                 hold on
                 set(h2,'EraseMode','xor')
                 u1=u1/max(u1);
                 u1=amplituda*u1;
                 set(h2,'Ydata',u1)
                 drawnow
                 % --- ovladani spojiteho 2D grafu c. 2 tazenim mysi -----------------
                 Maticegraf=get(findobj('Tag','Figure2'),'UserData'); % Handle plotu z funkce "graf"
                 h3=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 t2=Maticegraf(2,:); % osa casu
                 u2=Maticegraf(3,:); % osa vertikalni
                 amplituda=round(Yosa1/100);
                 %figure(findobj('Tag','Figure2'))
                 hold on
                 set(h3,'EraseMode','xor')
                 u2=u2/max(u2);
                 u2=amplituda*u2;
                 set(h3,'Ydata',u2)
                 drawnow
                 % --- ovladani spojiteho 2D grafu c. 3 tazenim mysi -----------------
                 Maticegraf=get(findobj('Tag','Figure3'),'UserData'); % Handle plotu z funkce "graf"
                 h4=Maticegraf(1,1); % Handle spojiteho grafu 2D
                 t3=Maticegraf(2,:); % osa casu
                 u3=Maticegraf(3,:); % osa vertikalni
                 u33=Maticegraf(4,:); % druha osa vertikalni
                 amplituda=round(Yosa1/100);
                 %figure(findobj('Tag','Figure2'))
                 hold on
                 set(h4,'EraseMode','xor')
                 u3=u3/max(u3);
                 u3=amplituda*u3;
                 u33=u33/max(u33);
                 u33=amplituda*u33;
                 set(h4,'Ydata',u3)
                 set(h4,'Xdata',u33)
                 drawnow
                 %QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ
                 %--------------------------------------------------------------------
              else   
              end
              %XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              %-----------------------------------------------------------------------
           else % jedna z os je zaporna, tedy mimo Axes, neudela se nic
           end
        case('klik+') % reakce na stisk tlacitka mysi
              % --- test, zda je pointer blizko krouzku ---
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 Detekce=1;
              else % mys neni dost blizko bodu
                 Detekce=0;
              end
           %--------------------------------------------
        case('klik-') % reakce na uvolneni tlacitka mysi
            
           if Detekce==1 % bod byl tazen pred uvolnenim mysi
              set(findobj('Tag','edit1'),'String',Xbod)
              set(findobj('Tag','edit2'),'String',Ybod)
              hold off 
              Detekce=0;
           else % bod nebyt prd uvolneni tazen (byl daleko)

           end 
        case('konec')
           close all
      end
  end
  
  %------------ Dalsi funkce v ramci m-souboru ------------------------------------------------------------
  %WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
  function graf1(Ybod) % pocatecni kresleni spojiteho 2D grafu c.1
     figure(findobj('Tag','Figure1'))
     t1=0:4*pi/100:4*pi;
     u1=round(Ybod/100)*sin(t1); % amplituda nastavena podle vertik. pozice cerveneho bodu v grafu
     h2=plot(t1,u1);
     axis([0 4*pi -50 50])
     grid on
     Maticegraf=zeros(3,length(t1));
     Maticegraf(1,1)=h2;
     Maticegraf(2,:)=t1;
     Maticegraf(3,:)=u1;     
     set(findobj('Tag','Figure1'),'UserData',Maticegraf) % uschovani h2,t1,u1
  function graf2(Ybod) % pocatecni kresleni spojiteho 2D grafu c.2
     figure(findobj('Tag','Figure2'))
     t2=0:4*pi/100:4*pi;
     u2=round(Ybod/100)*cos(t2); % amplituda nastavena podle vertik. pozice cerveneho bodu v grafu
     h3=plot(t2,u2);
     axis([0 4*pi -50 50])
     grid on
     Maticegraf=zeros(3,length(t2));
     Maticegraf(1,1)=h3;
     Maticegraf(2,:)=t2;
     Maticegraf(3,:)=u2;     
     set(findobj('Tag','Figure2'),'UserData',Maticegraf) % uschovani h3,t2,u2
  function graf3(Ybod) % pocatecni kresleni spojiteho 2D grafu c.3
     figure(findobj('Tag','Figure3'))
     t3=0:2*pi/100:2*pi;
     u3=round(Ybod/100)*sin(t3); % amplituda nastavena podle vertik. pozice cerveneho bodu v grafu
     u33=round(Ybod/100)*cos(t3); % amplituda nastavena podle vertik. pozice cerveneho bodu v grafu
     h4=plot(u3,u33);
     axis([-50 50 -50 50])
     grid on
     Maticegraf=zeros(4,length(t3));
     Maticegraf(1,1)=h4;
     Maticegraf(2,:)=t3;
     Maticegraf(3,:)=u3;
     Maticegraf(4,:)=u33;
     set(findobj('Tag','Figure3'),'UserData',Maticegraf) % uschovani h4,t3,u3,u33
     
  %WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW     
  % ------------------------------------ Prikazy k Pointeru -----------------------------------------------     
      %set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
      %set(0,'Pointerlocation',[800 800]) % v ramci Root nastavuje ci odecita souradnice pointeru
      %get(0,'PointerWindow') % vraci Handle okna, kde je pointer aktivni
      %get(0,'Pointerlocation') % vraci v ramci Root souradnice pointeru
      %Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
      %set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi02 pohyb') % vraci Handle objektu, jenz je vybran pointerem
%----------------------------------------------------------------------------------------------------------