% Funkce Tazenimysi01, programovani mysi ovladaneho kurzoru
% vytvoreno 1.10.2003
% ----------------------------------------------------------------------------
function Tazenimysi01(vstpar)
   global PolohaAxes Xplot Yplot Xmodul Ymodul Xbod Ybod Xlimit Ylimit Detekce h1 Mysuvolnena % definice globalnich promennych
   if nargin==0
      %------------------- kresleni grafickych objektu Figure a Uicontrol ---------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
      Monitor=get(0,'ScreenSize'); % rozliseni obrazovky monitoru
      F=figure('Units','Pixels','Name','Hlavn obrzek',... % vlastni vykresleni objektu Figure
               'Position',[0.37*Monitor(3) 0.49*Monitor(4) 0.3*Monitor(3) 0.25*Monitor(4)],...
               'Tag','Figure','Color',[0.9 0.7 0.6],...
               'NumberTitle','off','Resize','on','Menubar','none');
      A=axes('Units','Pixels',... % vlastni vykresleni objektu Figure
             'Position',[50 100 400 170],'Tag','Axes','Color','white');
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor On
                'Position',[0.13 0.03 0.16 0.08],'Tag','textcursoron',...
                'String','Cursor On','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor On
                'Position',[0.1 0.04 0.03 0.08],'Tag','radiocursoron',...
                'CallBack','Tazenimysi01 radiocursoron','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','text',...   % text pro Kurzor Off
                'Position',[0.5 0.03 0.16 0.08],'Tag','textcursoroff',...
                'String','Cursor Off','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','radio',...   % radio pro Kurzor Off
                'Position',[0.47 0.04 0.03 0.08],'Tag','radiocursoroff','Value',1,...
                'CallBack','Tazenimysi01 radiocursoroff','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',12);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose x
                'Position',[0.1 0.10 0.25 0.1],'Tag','text1',...
                'CallBack','Tazenimysi01 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Text',...   % text pro souradnice v ose y
                'Position',[0.40 0.10 0.35 0.1],'Tag','text2',...
                'CallBack','Tazenimysi01 text','ForegroundColor','black',...
                'BackgroundColor',get(gcf,'Color'),'FontWeight','bold','FontSize',18);
      uicontrol('Units','Normalized','Style','Push',...   % tlacitko Konec
                'Position',[0.81 0.05 0.16 0.15],'Tag','konec',...
                'String','Konec','CallBack','Tazenimysi01 konec','ForegroundColor','black',...
                'BackgroundColor','yellow','FontWeight','bold','FontSize',14);
  %-------------- Vykresleni bodu -------------
      Xbod=800;
      Ybod=800;
      Xlimit=10; % lokalizacni vzadlenost v ose x
      Ylimit=10; % lokalizacni vzadlenost v ose y
      h1=plot(Xbod,Ybod,'ro');
      set(h1,'Markersize',4)
      set(h1,'LineWidth',3)
      set(h1,'HitTest','off') % aby se daly odecist souradnice, kdyz je pointer primo na krouzku
      axis([700 900 700 900])
      Detekce=0; % bod nebyl implicitne vybran
      Mysuvolnena=0; % pro pozdejsi uvolneni talcitka mysi
   %------------------------------- reakce na Callback -------------------------------------
   %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
   else 
      switch(vstpar) 
        case('radiocursoron') % aktivace kurzoru
           set(findobj('Tag','radiocursoroff'),'Value',0) % deaktivace radio Curson Off
           set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi01 pohyb') % reakce na pohyb pointeru po Figure
              figure(findobj('Tag','Figure')); % aktivace Figure ( kdyby jich bylo vice)
              set(gca,'ButtonDownFcn','Tazenimysi01 klik+') % reakce na stisk mysi v ramci Axes
              set(gcf,'WindowButtonUpFcn','Tazenimysi01 klik-') % reakce na uvolneni mysi v ramci Axes
           figure(findobj('Tag','Figure')); % aktivace Figure ( kdyby jich bylo vice)
           PolohaAxes=get(gca,'Position'); % pozice Axes v ramci Figure
           Xplot=get(gca,'Xlim'); % min a max na vodorovne ose Plot
           Yplot=get(gca,'Ylim'); % min a max na slicle ose Plot
           Xmodul=(Xplot(2)-Xplot(1))/PolohaAxes(3); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose x
           Ymodul=(Yplot(2)-Yplot(1))/PolohaAxes(4); % jakou skut. hodnotu v Plot ma 1 pixel v Axes v ose y
           set(h1,'EraseMode','xor') % pro prekereslovani dale
       case('radiocursoroff') % deaktivace kurzoru
           set(findobj('Tag','radiocursoron'),'Value',0) % deaktivace radio Curson On
           set(findobj('Tag','Figure'),'Pointer','arrow') % v ramci Figure nastavi tvar pointeru zpet na sip
           set(findobj('Tag','Figure'),'WindowButtonMotionFcn',' ') % deaktivace
           set(findobj('Tag','text1'),'String',' '); % zmizeni souradnic
           set(findobj('Tag','text2'),'String',' '); % zmizeni souradnic
       case('pohyb')
           %--- zjisteni souradnic v ramxi Axes ---
           Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
           Xosa=Souradnice(1); % x-ova souradnice
           Yosa=Souradnice(2); % y-ova souradnice           
           Xosa1=Xosa-PolohaAxes(1); % aby 0 byla na zacastku Axes a ne Figure
           Yosa1=Yosa-PolohaAxes(2); % aby 0 byla na zacastku Axes a ne Figure
           %--- Osetreni zapornych poloh a maxim na obou osach v ramci Axes  ---
           if ((Xosa1>=0)&(Yosa1>=0))&((Xosa1<=PolohaAxes(3)))&(Yosa1<=PolohaAxes(4))
              %--- prepocet souradnic z meritka Axes na porad. cisla dat grafu ---
              Xosa1=Xmodul*Xosa1+Xplot(1);
              Yosa1=Ymodul*Yosa1+Yplot(1);
              Xosa1=num2str(Xosa1); % konverze x-ove souradnice na retezec              
              Yosa1=num2str(Yosa1); % konverze x-ove souradnice na retezec              
              set(findobj('Tag','text1'),'String',Xosa1); 
              set(findobj('Tag','text2'),'String',Yosa1);
                 Xosa11=str2num(Xosa1);
                 Yosa11=str2num(Yosa1);
              % --- zmena barvy bodu pri priblizeni ----
              Xdist=abs(Xosa11-Xbod); % vzalenost od krouzku v ose x
              Ydist=abs(Yosa11-Ybod); % vzalenost od krouzku v ose x
              [Xdist Ydist]
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 set(h1,'Color','blue')
              elseif (Xdist>Xlimit)|(Ydist>Ylimit)
                 set(h1,'Color','red') 
              end
              % --- reakce pri vyberu bodu mysi ---
              if (Detekce==1)&(Mysuvolnena==0) % byl lokalizovat bod a vybran pointerem
                 hold on
                 set(h1,'Xdata',Xosa11,'Ydata',Yosa11)
              elseif Mysuvolnena==1 % pusten bod mysi v nove pozici
              %if (Detekce==0)&(Mysuvolnena==1) % ulozeni bodu na nove pozici
                 hold off 
              end    
              %-------------------------------------    
           else % jedna z os je zaporna, tedy mimo Axes, neudela se nic
           end
        case('klik+') % reakce na stisk tlacitka mysi
           figure(findobj('Tag','Figure')); % aktivace Figure ( kdyby jich bylo vice)
           Souradnice=get(gcf,'CurrentPoint'); % souradnice mysi v ramci Axes
           Xosa=Souradnice(1); % x-ova souradnice pointeru
           Yosa=Souradnice(2); % y-ova souradnice pointeru  
           Xosa1=Xosa-PolohaAxes(1); % aby 0 byla na zacastku Axes a ne Figure
           Yosa1=Yosa-PolohaAxes(2); % aby 0 byla na zacastku Axes a ne Figure
           % --- aby nebyl pointer mimo ------------
           if ((Xosa1>=0)&(Yosa1>=0))&((Xosa1<=PolohaAxes(3)))&(Yosa1<=PolohaAxes(4))           
              Xosa1=Xmodul*Xosa1+Xplot(1);
              Yosa1=Ymodul*Yosa1+Yplot(1);
              Xdist=abs(Xosa1-Xbod); % vzalenost od krouzku v ose x
              Ydist=abs(Yosa1-Ybod); % vzalenost od krouzku v ose x
              % --- test, zda je pointer blizko krouzku ---
              if (Xdist<=Xlimit)&(Ydist<=Ylimit)
                 Detekce=1;
              else
                 Dtekce=0;
              end
           else
           end
           Mysuvolnena=0;
           %--------------------------------------------
        case('klik-') % reakce na uvolneni tlacitka mysi
           Mysuvolnena=1; 
           Souradnice=get(gcf,'CurrentPoint'); % souradnice mysi v ramci Axes
           Xosa=Souradnice(1); % x-ova souradnice pointeru
           Yosa=Souradnice(2); % y-ova souradnice pointeru  
           Xosa1=Xosa-PolohaAxes(1); % aby 0 byla na zacastku Axes a ne Figure
           Yosa1=Yosa-PolohaAxes(2); % aby 0 byla na zacastku Axes a ne Figure
           Xosa1=Xmodul*Xosa1+Xplot(1);
           Yosa1=Ymodul*Yosa1+Yplot(1);           
              Xbod=Xosa1; % nova pozice bodu v ose x
              Ybod=Yosa1; % nova pozice bodu v ose y    
          case('konec')
            close all
      end
  end
 
% ------------------------------------ Prikazy k Pointeru -------------------------------------------------     
      %set(findobj('Tag','Figure'),'Pointer','crosshair') % v ramci Figure nastavuje tvar (shape) pointeru
      %set(0,'Pointerlocation',[800 800]) % v ramci Root nastavuje ci odecita souradnice pointeru
      %get(0,'PointerWindow') % vraci Handle okna, kde je pointer aktivni
      %get(0,'Pointerlocation') % vraci v ramci Root souradnice pointeru
      %Souradnice=get(findobj('Tag','Figure'),'CurrentPoint'); % souradnice mysi v ramci Figure
      %set(findobj('Tag','Figure'),'WindowButtonMotionFcn','Tazenimysi01 pohyb') % vraci Handle objektu, jenz je vybran pointerem
%----------------------------------------------------------------------------------------------------------