% Funkce Program4, vypis dat a nacitaci a ukladani graficky
% vytvoreno 24.9.2003
% -------------------------------------------------------------------
function Program4(vstpar)
   if nargin==0 % jestlize je funkce volana bez vst. parametru
      %------------------- definice grafickych objektu Figure a Uicontrol ---------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
      Monitor=get(0,'ScreenSize'); % rozliseni obrazovky monitoru
      F=figure('Units','Pixels','Name','Grafick podpora vpisu, ukldn a natn dat',... % definice Figure
               'Position',[8 0.7*Monitor(4) 0.5*Monitor(3) 0.2*Monitor(4)],...
               'Tag','Figure1','Color',[0.8 0.8 0.8],...
               'NumberTitle','off','Resize','on','Menubar','none');
      F1=figure('Units','Pixels','Name','Vpis dat vektoru',... % definice Figure1
                'Position',[8 0.3*Monitor(4) 0.3*Monitor(3) 0.369*Monitor(4)],...
                'Tag','Figure2','Color',[0.8 0.8 0.8],'Visible','off',...
                'NumberTitle','off','Resize','on','Menubar','none');
      figure(F)
      h1=uicontrol('Units','Normalized','Style','Text',... % global text pro zadani vektoru
                   'Position',[0.35 0.75 0.25 0.15],'String','Zadani vektoru','Tag','text1',...
                   'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',18);
      h2=uicontrol('Units','Normalized','Style','Text',...   % text min
                   'Position',[0.1 0.55 0.05 0.15],'String','min','Tag','text2',...
                   'ForegroundColor','black','BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h3=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - minimum
                   'Position',[0.15 0.57 0.15 0.15],'Tag','min','String',0,...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h4=uicontrol('Units','Normalized','Style','Text',...   % text max
                   'Position',[0.32 0.55 0.05 0.15],'String','max','Tag','text3',...
                   'ForegroundColor','black','BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h5=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - maximum
                   'Position',[0.38 0.57 0.15 0.15],'Tag','max','String',1000,...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h6=uicontrol('Units','Normalized','Style','Text',...   % text pocet bodu
                   'Position',[0.535 0.55 0.15 0.15],'String','poc. bodu','Tag','text4',...
                   'ForegroundColor','black','BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h7=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - pocet bodu
                   'Position',[0.68 0.57 0.15 0.15],'Tag','pocbodu','String',100,...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h8=uicontrol('Units','Normalized','Style','Push',...   % Push - vypis dat
                   'Position',[0.15 0.2 0.15 0.2],'Tag','vypis','String','Vypis dat',...
                   'ForegroundColor','white','BackgroundColor','blue',...
                   'CallBack','Program4 vypis','FontWeight','bold','FontSize',13);
      h9=uicontrol('Units','Normalized','Style','Push',...   % Push - konec
                   'Position',[0.88 0.06 0.1 0.18],'Tag','konec','String','Konec',...
                   'ForegroundColor','white','BackgroundColor','red',...
                   'Callback','Program4 konec','FontWeight','bold','FontSize',13);
      h10=uicontrol(F1,'Units','Normalized','Style','Push',...   % Push - save
                    'Position',[0.6 0.84 0.25 0.11],'Tag','save','String','Save Data',...
                    'ForegroundColor','black','BackgroundColor','green',...
                    'Callback','Program4 save','FontWeight','bold','FontSize',13);
      h11=uicontrol(F1,'Units','Normalized','Style','Push',...   % Push - load
                    'Position',[0.6 0.64 0.25 0.11],'Tag','load','String','Load Data',...
                    'ForegroundColor','black','BackgroundColor','green',...
                    'Callback','Program4 load','FontWeight','bold','FontSize',13);
      h12=uicontrol(F1,'Units','Normalized','Style','list',...   % List - vypis dat
                       'Position',[0.1 0.05 0.4 0.9],'Tag','list','String','Vlastn vpis dat',...
                       'ForegroundColor','white','BackgroundColor','blue','Visible','off',...
                       'FontWeight','bold','FontSize',13);
      %---------------------------- reakce na stisk tlacitka ----------------------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
   else % jestlize je funcke volana se vst. parametrem (vola sama sebe)
      switch(vstpar) % prepinac odezev objektu Uicontrol
         case('vypis') % reakce na stisk tlacitka pro vypocet a vypis dat
             F1=findobj('Tag','Figure2'); % urceni Handle figure2
             set(F1,'visible','on'); % viditelnost figure2
             set(findobj('Tag','list'),'visible','on'); % viditelnost Listboxu pro vypis dat
             Min=str2num(get(findobj('Tag','min'),'String')); % nasteni minima
             Max=str2num(get(findobj('Tag','max'),'String')); % nasteni maxima
             Pocbodu=str2num(get(findobj('Tag','pocbodu'),'String')); % nasteni postu bodu
             Vektor=Min:(Max-Min)/(Pocbodu-1):Max; % tvorba vektoru
             Vektor1=Vektor'; % sloupcovy vektor z radkoveho
             set(findobj('Tag','Figure2'),'UserData',Vektor1); % ulozeni pro pozdejsi nacteni v dalsich "case"
             Vektor2=num2str(Vektor1); % konverze na string pro vypis
             set(findobj('Tag','list'),'String',Vektor2) % vlastni zobrazeni dat v Listbox
         case('save')
            Vektor1=get(findobj('Tag','Figure2'),'UserData');
            [jmeno,adresar]=uiputfile('*.*','Uloit jako ASCII data ...');
            if jmeno==0 % volba "Storno" v menu pro uloen souboru typu *.mat
            else
               save([adresar,jmeno],'Vektor1','-ascii');
            end
        case('load')
            [jmeno,adresar]=uigetfile('*.*','Naten souboru dat ASCII ...');
            if jmeno==0 % volba "Storno" v menu pro naten souboru typu *.*
            else
               Vektor1=load([adresar,jmeno],'-ascii');
               set(findobj('Tag','list'),'String',num2str(Vektor1));  % zapis do okna Listboxu
            end
        case('konec') % reakce na stisk tlacitka "Konec"        
            close all
      end
   end
   
   