% Funkce Program3, prace s grafem
% vytvoreno 18.9.2003
% -------------------------------------------------------------------
function Program3(vstpar)
   if nargin==0 % jestlize je funkce volana bez vst. paarametru
      %------------------- definice grafickych objektu Figure a Uicontrol ---------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
      Monitor=get(0,'ScreenSize'); % rozliseni obrazovky monitoru
      F=figure('Units','Pixels','Name','Demonstrace prce s grafem',... % vlastni vykresleni objektu Figure
               'Position',[1 0.75*Monitor(4) 0.7*Monitor(3) 0.15*Monitor(4)],...
               'Tag','Figure1','Color',[0.8 0.8 0.8],...
               'NumberTitle','off','Resize','on','Menubar','none');
           
      F1=figure('Units','Pixels','Name','Kreslen vybran funkce',... % objekt Figure pro kresleni grafu
               'Position',[1 0.3*Monitor(4) 0.41*Monitor(3) 0.42*Monitor(4)],...
               'Tag','Figure2','Color',[0.8 0.8 0.8],'Visible','off',...
               'NumberTitle','off','Resize','on','Menubar','none');
      figure(F) % aktivni figure s Handle F (do nej se budou krelsit nasledujici objekty Uicontrol)
      h1=uicontrol('Units','Normalized','Style','Popup',...  % menu pro vyber funkce
                   'Position',[0.05 0.55 0.15 0.2],'Tag','popup1',...
                   'String','Sinus|Kosinus|Tangens|Kotangens',...
                   'CallBack','Program3 funkce','ForegroundColor','blue',...
                   'BackgroundColor','yellow','FontWeight','bold','FontSize',13);
      h2=uicontrol('Units','Normalized','Style','Text',...   % text nad popup1
                   'Position',[0.05 0.78 0.15 0.15],'String','Vyber funkci','Tag','text1',...
                   'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',14);
      h3=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - definice minima osy x
                   'Position',[0.28 0.57 0.1 0.18],'Tag','xmin','String',0,...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h4=uicontrol('Units','Normalized','Style','Text',...   % text osa x-min
                   'Position',[0.23 0.59 0.05 0.15],'String','min','Tag','text2',...
                   'ForegroundColor','black','BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h5=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - definice maxima osy x
                   'Position',[0.455 0.57 0.1 0.18],'Tag','xmax','String',4*pi,...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h6=uicontrol('Units','Normalized','Style','Text',...   % text osa x-mmax
                   'Position',[0.4 0.59 0.05 0.15],'String','max','Tag','text3',...
                   'ForegroundColor','black','BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h7=uicontrol('Units','Normalized','Style','Text',...   % global text nad definici osy x
                   'Position',[0.35 0.78 0.15 0.15],'String','Zadej meze osy x','Tag','text4',...
                   'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',14);
      h8=uicontrol('Units','Normalized','Style','Edit',...   % Edit text - pocet bodu grafu
                   'Position',[0.28 0.16 0.1 0.18],'String','100','Tag','pocbodu',...
                   'ForegroundColor','blue','BackgroundColor','yellow',...
                   'FontWeight','bold','FontSize',13);
      h9=uicontrol('Units','Normalized','Style','Text',...   % Text - pocet bodu
                   'Position',[0.255 0.35 0.15 0.15],'String','Poet bod','Tag','text5',...
                   'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                   'FontWeight','bold','FontSize',13);
      h10=uicontrol('Units','Normalized','Style','Push',...  % tlacitko "Vypocet"
                    'Position',[0.455 0.16 0.1 0.3],'String','Vpoet','Tag','vypocet',...
                    'ForegroundColor','white','BackgroundColor','red','Callback','Program3 vypocet',...
                    'FontWeight','bold','FontSize',16);
      h11=uicontrol('Units','Normalized','Style','Popup',...  % menu pro barvu cary
                    'Position',[0.6 0.55 0.1 0.2],'Tag','popup2',...
                    'String','Red|Blue|Green|Black','Enable','off',...
                    'Callback','Program3 barvacary','ForegroundColor','blue',...
                    'BackgroundColor','white','FontWeight','bold','FontSize',13);
      h12=uicontrol('Units','Normalized','Style','Text',...   % text barva cary
                    'Position',[0.577 0.78 0.15 0.15],'String','Barva cary','Tag','text6',...
                    'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                    'FontWeight','bold','FontSize',14);
      h13=uicontrol('Units','Normalized','Style','Popup',...  % menu pro tloustku cary
                    'Position',[0.725 0.55 0.1 0.2],'Tag','popup3',...
                    'String','1|3|5|7','Enable','off',...
                    'Callback','Program3 tloustkacary','ForegroundColor','blue',...
                    'BackgroundColor','white','FontWeight','bold','FontSize',13);
      h14=uicontrol('Units','Normalized','Style','Text',...   % text barva cary
                    'Position',[0.7 0.78 0.15 0.15],'String','Tloustka cary','Tag','text7',...
                    'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                    'FontWeight','bold','FontSize',14);
      h15=uicontrol('Units','Normalized','Style','Popup',...  % menu pro tloustku cary
                    'Position',[0.86 0.55 0.1 0.2],'Tag','popup4',...
                    'String','-|- - -|. - . -|. . . .','Enable','off',...
                    'Callback','Program3 stylcary','ForegroundColor','blue',...
                    'BackgroundColor','white','FontWeight','bold','FontSize',13);
      h16=uicontrol('Units','Normalized','Style','Text',...   % text barva cary
                    'Position',[0.835 0.78 0.15 0.15],'String','Styl cary','Tag','text8',...
                    'ForegroundColor',[0.7 0.2 0],'BackgroundColor',get(gcf,'Color'),...
                    'FontWeight','bold','FontSize',14);
      h17=uicontrol('Units','Normalized','Style','Push',...  % tlacitko "Konec"
                    'Position',[0.86 0.16 0.1 0.3],'String','Konec','Tag','konec',...
                    'ForegroundColor','black','BackgroundColor','Green','Callback','Program3 konec',...
                    'FontWeight','bold','FontSize',16);             
      %---------------------------- reakce na stisk tlacitka ----------------------------------
      %OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO
   else % jestlize je funcke volana se vst. parametrem (vola sama sebe)
      switch(vstpar) % prepinac odezev objektu Uicontrol
         case('vypocet') % reakce na stisk tlacitka pro vypocet
            Funkce=get(findobj('Tag','popup1'),'Value'); % nacteni poradoveho cisla vybrane funkce
            Xmin=str2num(get(findobj('Tag','xmin'),'String')); % nacteni minima na ose X
            Xmax=str2num(get(findobj('Tag','xmax'),'String')); % nacteni maxima na ose X
            Pocbodu=str2num(get(findobj('Tag','pocbodu'),'String')); % nacteni poctu bodu na ose X
            Vektor=Program33(Funkce,Xmin,Xmax,Pocbodu); % volani funkce pro vypocet vektoru na osach X a Y 
            F1=findobj('Tag','Figure2'); % zjisteni Handle Figure2 (neni jiz k dispozici)
            set(F1,'Visible','on'); % figure pro kresleni grafu
            figure(F1) % aktivni bude Figure2, kreslit se tedy bude do nej
            plot(Vektor(1,:),Vektor(2,:)) % kresleni vybrane funkce
            axis([Xmin Xmax -Inf Inf]) % uprava rozsahu os
            set(gca,'Color',get(findobj('Tag','Figure1'),'Color')) % stejna barva pozadi jako Figure1
            set(findobj('Tag','popup2'),'Enable','on'); % volba barvy cary je aktivni
            set(findobj('Tag','popup3'),'Enable','on'); % volba tloustky cary je aktivni
            set(findobj('Tag','popup4'),'Enable','on'); % volba stylu cary je aktivni
         case('barvacary') % nastaveni barvy cary grafu
            Barvacary=get(findobj('Tag','popup2'),'Value'); % jaka barva cary je zvolena
            F1=findobj('Tag','Figure2');
            figure(F1); % aktivni Figure2
            switch Barvacary 
            case(1)
                set(get(gca,'children'),'Color','red') 
            case(2)
                set(get(gca,'children'),'Color','blue') 
            case(3)
                set(get(gca,'children'),'Color','green') 
            case(4)
                set(get(gca,'children'),'Color','black') 
            end
         case('tloustkacary') % nastaveni tloustky cary grafu
            Tloustkacary=get(findobj('Tag','popup3'),'Value'); % jaka barva cary je zvolena
            F1=findobj('Tag','Figure2');
            figure(F1); % aktivni Figure2
            switch Tloustkacary
            case(1)
                set(get(gca,'children'),'LineWidth',1) 
            case(2)
                set(get(gca,'children'),'LineWidth',3) 
            case(3)
                set(get(gca,'children'),'LineWidth',5) 
            case(4)
                set(get(gca,'children'),'LineWidth',7) 
            end
        case('stylcary') % nastaveni tloustky cary grafu
            Stylcary=get(findobj('Tag','popup4'),'Value'); % jaka barva cary je zvolena
            F1=findobj('Tag','Figure2');
            figure(F1); % aktivni Figure2
            switch Stylcary
            case(1)
                set(get(gca,'children'),'LineStyle','-') 
            case(2)
                set(get(gca,'children'),'LineStyle','--') 
            case(3)
                set(get(gca,'children'),'LineStyle','-.') 
            case(4)
                set(get(gca,'children'),'LineStyle',':') 
            end            
        case('konec') % reakce na stisk tlacitka "Konec"        
            close all
      end
   end
   